% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fweibullgpdcon.r
\name{fweibullgpdcon}
\alias{fweibullgpdcon}
\alias{lweibullgpdcon}
\alias{nluweibullgpdcon}
\alias{nlweibullgpdcon}
\alias{profluweibullgpdcon}
\title{MLE Fitting of Weibull Bulk and GPD Tail Extreme Value Mixture Model with Single Continuity Constraint}
\usage{
fweibullgpdcon(x, phiu = TRUE, useq = NULL, fixedu = FALSE,
  pvector = NULL, std.err = TRUE, method = "BFGS", control = list(maxit
  = 10000), finitelik = TRUE, ...)

lweibullgpdcon(x, wshape = 1, wscale = 1, u = qweibull(0.9, wshape,
  wscale), xi = 0, phiu = TRUE, log = TRUE)

nlweibullgpdcon(pvector, x, phiu = TRUE, finitelik = FALSE)

profluweibullgpdcon(u, pvector, x, phiu = TRUE, method = "BFGS",
  control = list(maxit = 10000), finitelik = FALSE, ...)

nluweibullgpdcon(pvector, u, x, phiu = TRUE, finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{phiu}{probability of being above threshold \eqn{(0, 1)} or logical, see Details in
help for \code{\link[evmix:fnormgpd]{fnormgpd}}}

\item{useq}{vector of thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedu}{logical, should threshold be fixed (at either scalar value in \code{useq},
or estimated from maximum of profile likelihood evaluated at
sequence of thresholds in \code{useq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{wshape}{scalar Weibull shape (positive)}

\item{wscale}{scalar Weibull scale (positive)}

\item{u}{scalar threshold value}

\item{xi}{scalar shape parameter}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}
}
\value{
Log-likelihood is given by \code{\link[evmix:fweibullgpdcon]{lweibullgpdcon}} and it's
  wrappers for negative log-likelihood from \code{\link[evmix:fweibullgpdcon]{nlweibullgpdcon}}
  and \code{\link[evmix:fweibullgpdcon]{nluweibullgpdcon}}. Profile likelihood for single
  threshold given by \code{\link[evmix:fweibullgpdcon]{profluweibullgpdcon}}. Fitting function
  \code{\link[evmix:fweibullgpdcon]{fweibullgpdcon}} returns a simple list with the
  following elements

\tabular{ll}{
 \code{call}:      \tab \code{optim} call\cr
 \code{x}:         \tab data vector \code{x}\cr
 \code{init}:      \tab \code{pvector}\cr
 \code{fixedu}:    \tab fixed threshold, logical\cr
 \code{useq}:      \tab threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{nllhuseq}:  \tab profile negative log-likelihood at each threshold in useq\cr
 \code{optim}:     \tab complete \code{optim} output\cr
 \code{mle}:       \tab vector of MLE of parameters\cr
 \code{cov}:       \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:        \tab vector of standard errors of MLE of parameters\cr
 \code{rate}:      \tab \code{phiu} to be consistent with \code{\link[evd:fpot]{evd}}\cr
 \code{nllh}:      \tab minimum negative log-likelihood\cr
 \code{n}:         \tab total sample size\cr
 \code{wshape}:    \tab MLE of Weibull shape\cr
 \code{wscale}:    \tab MLE of Weibull scale\cr
 \code{u}:         \tab threshold (fixed or MLE)\cr
 \code{sigmau}:    \tab MLE of GPD scale (estimated from other parameters)\cr
 \code{xi}:        \tab MLE of GPD shape\cr
 \code{phiu}:      \tab MLE of tail fraction (bulk model or parameterised approach)\cr
 \code{se.phiu}:   \tab standard error of MLE of tail fraction\cr
}
}
\description{
Maximum likelihood estimation for fitting the extreme value
mixture model with Weibull for bulk distribution upto the threshold and conditional
GPD above threshold with continuity at threshold. With options for profile likelihood estimation for threshold and
fixed threshold approach.
}
\details{
The extreme value mixture model with Weibull bulk and GPD tail with continuity at threshold is
fitted to the entire dataset using maximum likelihood estimation. The estimated
parameters, variance-covariance matrix and their standard errors are automatically
output.

See help for \code{\link[evmix:fnormgpd]{fnormgpd}} for details, type \code{help fnormgpd}.
Only the different features are outlined below for brevity.

The GPD \code{sigmau} parameter is now specified as function of other parameters, see
help for \code{\link[evmix:weibullgpdcon]{dweibullgpdcon}} for details, type \code{help weibullgpdcon}.
Therefore, \code{sigmau} should not be included in the parameter vector if initial values
are provided, making the full parameter vector
(\code{wshape}, \code{wscale}, \code{u}, \code{xi}) if threshold is also estimated and
(\code{wshape}, \code{wscale}, \code{xi}) for profile likelihood or fixed threshold approach.

Negative data are ignored.
}
\note{
When \code{pvector=NULL} then the initial values are:
\itemize{
 \item MLE of Weibull parameters assuming entire population is Weibull; and
 \item threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of GPD shape parameter above threshold.
}
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}.
}
\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 1))

x = rweibull(1000, shape = 2)
xx = seq(-0.1, 4, 0.01)
y = dweibull(xx, shape = 2)

# Continuity constraint
fit = fweibullgpdcon(x)
hist(x, breaks = 100, freq = FALSE, xlim = c(-0.1, 4))
lines(xx, y)
with(fit, lines(xx, dweibullgpdcon(xx, wshape, wscale, u, xi), col="red"))
abline(v = fit$u, col = "red")

# No continuity constraint
fit2 = fweibullgpd(x, phiu = FALSE)
with(fit2, lines(xx, dweibullgpd(xx, wshape, wscale, u, sigmau, xi, phiu), col="blue"))
abline(v = fit2$u, col = "blue")
legend("topright", c("True Density","No continuity constraint","With continuty constraint"),
  col=c("black", "blue", "red"), lty = 1)

# Profile likelihood for initial value of threshold and fixed threshold approach
fitu = fweibullgpdcon(x, useq = seq(0.5, 2, length = 20))
fitfix = fweibullgpdcon(x, useq = seq(0.5, 2, length = 20), fixedu = TRUE)

hist(x, breaks = 100, freq = FALSE, xlim = c(-0.1, 4))
lines(xx, y)
with(fit, lines(xx, dweibullgpdcon(xx, wshape, wscale, u, xi), col="red"))
abline(v = fit$u, col = "red")
with(fitu, lines(xx, dweibullgpdcon(xx, wshape, wscale, u, xi), col="purple"))
abline(v = fitu$u, col = "purple")
with(fitfix, lines(xx, dweibullgpdcon(xx, wshape, wscale, u, xi), col="darkgreen"))
abline(v = fitfix$u, col = "darkgreen")
legend("topright", c("True Density","Default initial value (90\% quantile)",
 "Prof. lik. for initial value", "Prof. lik. for fixed threshold"),
 col=c("black", "red", "purple", "darkgreen"), lty = 1)
}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Weibull_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Hu, Y. (2013). Extreme value mixture modelling: An R package and simulation study.
MSc (Hons) thesis, University of Canterbury, New Zealand.
\url{http://ir.canterbury.ac.nz/simple-search?query=extreme&submit=Go}

Behrens, C.N., Lopes, H.F. and Gamerman, D. (2004). Bayesian analysis of extreme
events with threshold estimation. Statistical Modelling. 4(3), 227-244.
}
\seealso{
\code{\link[stats:Weibull]{dweibull}},
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}

Other weibullgpd weibullgpdcon fweibullgpd fweibullgpdcon normgpd fnormgpd: \code{\link{fweibullgpd}},
  \code{\link{fweibullgpd}}, \code{\link{fweibullgpd}},
  \code{\link{fweibullgpd}}, \code{\link{fweibullgpd}},
  \code{\link{lweibullgpd}}, \code{\link{lweibullgpd}},
  \code{\link{lweibullgpd}}, \code{\link{lweibullgpd}},
  \code{\link{lweibullgpd}}, \code{\link{nluweibullgpd}},
  \code{\link{nluweibullgpd}}, \code{\link{nluweibullgpd}},
  \code{\link{nluweibullgpd}}, \code{\link{nluweibullgpd}},
  \code{\link{nlweibullgpd}}, \code{\link{nlweibullgpd}},
  \code{\link{nlweibullgpd}}, \code{\link{nlweibullgpd}},
  \code{\link{nlweibullgpd}},
  \code{\link{profluweibullgpd}},
  \code{\link{profluweibullgpd}},
  \code{\link{profluweibullgpd}},
  \code{\link{profluweibullgpd}},
  \code{\link{profluweibullgpd}}
}

