% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhyloCompare.R
\name{PhyloCompare}
\alias{PhyloCompare}
\title{Compares sister groups}
\usage{
PhyloCompare(tree, node.data, ComparisonFunc = PCAsimilarity, ...)
}
\arguments{
\item{tree}{phylogenetic tree}

\item{node.data}{list of node data}

\item{ComparisonFunc}{comparison function, default is PCAsimilarity}

\item{...}{Aditional arguments passed to ComparisonFunc}
}
\value{
list with a data.frame of calculated comparisons for each node, using labels or numbers from tree; and a list of comparisons for plotting using phytools (see examples)
}
\description{
Calculates the comparison of some statistic between sister groups along a phylogeny
}
\note{
Phylogeny must be fully resolved
}
\examples{
library(ape)
data(bird.orders)
tree <- bird.orders
mat.list <- RandomMatrix(5, length(tree$tip.label))
names(mat.list) <- tree$tip.label
sample.sizes <- runif(length(tree$tip.label), 15, 20)
phylo.state <- PhyloW(tree, mat.list, sample.sizes)

phylo.comparisons <- PhyloCompare(tree, phylo.state)

# plotting results on a phylogeny:
\dontrun{
library(phytools)
plotBranchbyTrait(tree, phylo.comparisons[[2]])
}
}
\author{
Diogo Melo
}
