% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrzSubspace.R
\name{KrzSubspace}
\alias{KrzSubspace}
\title{Krzanowski common subspaces analysis}
\usage{
KrzSubspace(cov.matrices, k = NULL)
}
\arguments{
\item{cov.matrices}{list of covariance matrices}

\item{k}{number of dimentions to be retained in calculating the subspace}
}
\value{
H shared space matrix

k_eVals_H eigen values for shared space matrix, maximum value for each is the number of matrices, representing a fully shared direction

k_eVecs_H eigen vectors of shared space matrix

angles between each population subspace and each eigen vector of shared space matrix
}
\description{
Calculates the subspace most similar across a set of covariance matrices.
}
\note{
can be used to inplement the Baysean comparsion from Aguirre et al. 2014
}
\examples{
data(dentus)
dentus.matrices = dlply(dentus, .(species), function(x) cov(x[-5]))
KrzSubspace(dentus.matrices, k = 2)

\dontrun{
# The method in Aguirre et al. 2014 can de implemented usign this function as follows:

#Random input data with dimensions traits x traits x populations x MCMCsamples:
cov.matrices = aperm(aaply(1:10, 1, function(x) laply(RandomMatrix(6, 40,                    
                                                      variance = runif(6,1, 10)), 
                           identity)), 
                     c(3, 4, 1, 2))
   
library(magrittr)
Hs = alply(cov.matrices, 4, function(x) alply(x, 3)) \%>\% llply(function(x) KrzSubspace(x, 3)$H)
avgH = Reduce("+", Hs)/length(Hs)
avgH.vec <- eigen(avgH)$vectors
MCMC.H.val = laply(Hs, function(mat) diag(t(avgH.vec) \%*\% mat \%*\% avgH.vec))

# confidence intervals for variation in shared subspace directions
library(coda)
HPDinterval(as.mcmc(MCMC.H.val))    
}
}
\references{
Aguirre, J. D., E. Hine, K. McGuigan, and M. W. Blows. "Comparing G: multivariate analysis of genetic variation in multiple populations." Heredity 112, no. 1 (2014): 21-29.
}
