% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demand.R
\name{get_n_connections}
\alias{get_n_connections}
\title{Obtain time series of EV connected from sessions data set}
\usage{
get_n_connections(
  sessions,
  dttm_seq = NULL,
  by = "Profile",
  resolution = 15,
  mc.cores = 1
)
}
\arguments{
\item{sessions}{tibble, sessions data set in standard format marked by \code{{evprof}} package
(see \href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{this article})}

\item{dttm_seq}{sequence of datetime values that will be the \code{datetime}
variable of the returned time-series data frame.}

\item{by}{character, being 'Profile' or 'Session'. When \code{by='Profile'} each column corresponds to an EV user profile.}

\item{resolution}{integer, time resolution (in minutes) of the sessions datetime variables.
If \code{dttm_seq} is defined this parameter is ignored.}

\item{mc.cores}{integer, number of cores to use.
Must be at least one, and parallelization requires at least two cores.}
}
\value{
tibble
}
\description{
Obtain time series of EV connected from sessions data set
}
\examples{
library(lubridate)
library(dplyr)

# Get occupancy with the complete datetime sequence from the sessions
sessions <- head(evsim::california_ev_sessions, 100)
get_n_connections(
  sessions,
  by = "Session",
  resolution = 60
)

# Get occupancy with a custom datetime sequence and resolution of 15 minutes
sessions <- head(evsim::california_ev_sessions_profiles, 100)
dttm_seq <- seq.POSIXt(
  as_datetime(dmy(01102018)) \%>\% force_tz(tz(sessions$ConnectionStartDateTime)),
  as_datetime(dmy(07102018)) \%>\% force_tz(tz(sessions$ConnectionStartDateTime)),
  by = "15 mins"
)
get_n_connections(
  sessions,
  dttm_seq = dttm_seq,
  by = "Profile",
  resolution = 15
)

}
