% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/human-SIP.R
\name{make_parameters_X_SIP}
\alias{make_parameters_X_SIP}
\title{Make parameters for SIP human model}
\usage{
make_parameters_X_SIP(pars, b, c, r, rho, eta, Psi, wf = 1, X0, P0, H)
}
\arguments{
\item{pars}{an \link{environment}}

\item{b}{transmission probability (efficiency) from mosquito to human}

\item{c}{transmission probability (efficiency) from human to mosquito}

\item{r}{recovery rate}

\item{rho}{probability of successful treatment upon infection}

\item{eta}{prophylaxis waning rate}

\item{Psi}{a \link{matrix} of dimensions \code{nPatches} by \code{nStrata}}

\item{wf}{vector of biting weights of length \code{nStrata}}

\item{X0}{size of infected population in each strata}

\item{P0}{size of population protected by prophylaxis in each strata}

\item{H}{size of human population in each strata}
}
\value{
a \link{list} with class \code{SIP}.
}
\description{
Make parameters for SIP human model
}
