% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_moving_average.R
\name{ts_moving_average}
\alias{ts_moving_average}
\alias{ts_ma}
\title{Moving Average}
\usage{
ts_moving_average(ts, order)

ts_ma(ts, order)
}
\arguments{
\item{ts}{a \code{ts_data} object}

\item{order}{integer: order of the moving average}
}
\value{
Returns an extended \code{ts_data} object with list elements:
\itemize{
\item \code{filter} the filter used
\item \code{moving.average} the computed moving average
}
}
\description{
Computes the moving average for a \code{ts_data} object.
}
\examples{
# trend from a quadratic model
ts <- ts_data(12, trend.coeff=c(sample(0:10, 1), sample(1+(1:10)/20, 1), 0.5))
ts_moving_average(ts, 3)
}
