% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{check_progress}
\alias{check_progress}
\title{Check for survey progress}
\usage{
check_progress(
  x,
  min_progress = 100,
  id_col = "ResponseId",
  finished_col = "Finished",
  progress_col = "Progress",
  keep = FALSE,
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{min_progress}{Amount of progress considered acceptable to include.}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{finished_col}{Column name for whether survey was completed.}

\item{progress_col}{Column name for percentage of survey completed.}

\item{keep}{Logical indicating whether to keep or remove exclusion column.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
The output is a data frame of the rows
that have incomplete progress.
For a function that marks these rows, use \code{\link[=mark_progress]{mark_progress()}}.
For a function that excludes these rows, use \code{\link[=exclude_progress]{exclude_progress()}}.
}
\description{
The \code{check_progress()} function subsets rows of data, retaining rows
that have incomplete progress.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
The default requires 100\% completion, but lower levels of completion
maybe acceptable and can be allowed by specifying the \code{min_progress}
argument.
The finished column in Qualtrics can be a numeric or character vector
depending on whether it is exported as choice text or numeric values.
This function works for both.

The function outputs to console a message about the number of rows
that have incomplete progress.
}
\examples{
# Check for rows with incomplete progress
data(qualtrics_text)
check_progress(qualtrics_text)

# Remove preview data first
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_progress()

# Include a lower acceptable completion percentage
qualtrics_numeric \%>\%
  exclude_preview() \%>\%
  check_progress(min_progress = 98)

# Do not print rows to console
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_progress(print = FALSE)

# Do not print message to console
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_progress(quiet = TRUE)
}
\seealso{
Other progress functions: 
\code{\link{exclude_progress}()},
\code{\link{mark_progress}()}

Other check functions: 
\code{\link{check_duplicates}()},
\code{\link{check_duration}()},
\code{\link{check_ip}()},
\code{\link{check_location}()},
\code{\link{check_preview}()},
\code{\link{check_resolution}()}
}
\concept{check functions}
\concept{progress functions}
