% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_testthat.R
\name{exc_safe_inla}
\alias{exc_safe_inla}
\title{Load INLA safely for examples and tests}
\usage{
exc_safe_inla(multicore = NULL, quietly = FALSE)
}
\arguments{
\item{multicore}{logical; if `TRUE`, multiple cores are allowed, and the
INLA `num.threads` option is not checked or altered.
If `FALSE`, forces `num.threads="1:1"`. Default: NULL, checks
if running in testthat or non-interactively, in which case sets
`multicore=FALSE`, otherwise `TRUE`.}

\item{quietly}{logical; if `TRUE`, prints diagnostic messages. Default: FALSE.}
}
\value{
logical; `TRUE` if INLA was loaded safely, otherwise FALSE
}
\description{
Loads the INLA package with `requireNamespace("INLA", quietly = TRUE)`, and
optionally checks and sets the multicore `num.threads` INLA option.
}
\examples{
\dontrun{
if (exc_safe_inla()) {
  # Run inla dependent calculations
}
}

}
