/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Subpopulation;
import core.utils.AFtimesCopyNumber;
import core.utils.Common;
import core.utils.CopyNumber;
import core.utils.NotAValidCompositionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class ParallelSubpopulations {
    private LinkedHashSet<Subpopulation> snvBeforeCNV = new LinkedHashSet();
    private LinkedHashSet<Subpopulation> snvAfterCNV = new LinkedHashSet();
    private LinkedHashSet<Subpopulation> snvSiblingOfCNV = new LinkedHashSet();

    public ParallelSubpopulations(double cn, double af, int pnb, boolean enforceCoocurrence, int backgroundploidy) throws NotAValidCompositionException {
        Subpopulation root = new Subpopulation(1.0, backgroundploidy, pnb, null);
        HashSet<Subpopulation> sps = root.getPotentialChildren(new CopyNumber(cn));
        for (Subpopulation sp : sps) {
            AFtimesCopyNumber afxcn = new AFtimesCopyNumber(af * cn);
            if (enforceCoocurrence || root.getPmb() == 1) {
                Common.setALLOWED_SP_FREQUENCIES(new double[]{sp.getCellularFrequency()});
            } else {
                this.snvBeforeCNV.addAll(sp.getPotentialParents(afxcn));
                this.snvSiblingOfCNV.addAll(sp.getPotentialSiblings(afxcn));
            }
            this.snvAfterCNV.addAll(sp.getPotentialChildren(afxcn));
        }
    }

    public Map<Double, Double> getCellFreq2ProbabilityMap() {
        Map<Subpopulation, Double> m = this.getSubpopulation2ProbabilityMap();
        HashMap<Double, Double> d = new HashMap<Double, Double>();
        for (Subpopulation tsp : m.keySet()) {
            ArrayList<Subpopulation> sps = new ArrayList<Subpopulation>();
            sps.add(tsp);
            if (tsp.getChild() != null) {
                sps.add(tsp.getChild());
            }
            if (tsp.getSibling() != null) {
                sps.add(tsp.getSibling());
            }
            if (!tsp.getParent().equals(tsp.getRoot())) {
                sps.add(tsp.getParent());
            }
            for (Subpopulation sp : sps) {
                double value = 1.0 / (sp.getAbsoluteDeviation() * sp.getRoot().eventsTo(sp));
                if (d.containsKey(sp.getCellularFrequency())) {
                    value += ((Double)d.get(sp.getCellularFrequency())).doubleValue();
                }
                d.put(sp.getCellularFrequency(), value);
            }
        }
        return d;
    }

    public Map.Entry<Subpopulation, Double> getBestFittingSubpopulation() {
        Map<Subpopulation, Double> all = this.getSubpopulation2ProbabilityMap();
        double pmax = Double.MIN_VALUE;
        Map.Entry<Subpopulation, Double> sp = null;
        for (Map.Entry<Subpopulation, Double> e : all.entrySet()) {
            if (!(pmax <= e.getValue())) continue;
            pmax = e.getValue();
            sp = e;
        }
        return sp;
    }

    public Map<Subpopulation, Double> getSubpopulation2ProbabilityMap() {
        double value;
        double x;
        HashMap<Subpopulation, Double> d = new HashMap<Subpopulation, Double>();
        for (Subpopulation sp : this.snvBeforeCNV) {
            x = sp.getAbsoluteDeviation() + sp.getChild().getAbsoluteDeviation();
            value = 1.0 / (x * (sp.getRoot().eventsTo(sp) + sp.eventsTo(sp.getChild())));
            if (d.containsKey(sp)) {
                value += ((Double)d.get(sp)).doubleValue();
            }
            d.put(sp, value);
        }
        for (Subpopulation sp : this.snvAfterCNV) {
            x = sp.getParent().getAbsoluteDeviation() + sp.getAbsoluteDeviation();
            value = Math.log(sp.getParent().eventsTo(sp)) == 0.0 ? 1.0 / (x * sp.getRoot().eventsTo(sp)) : 1.0 / (x * (sp.getRoot().eventsTo(sp.getParent()) + sp.getParent().eventsTo(sp)));
            if (d.containsKey(sp)) {
                value += ((Double)d.get(sp)).doubleValue();
            }
            d.put(sp, value);
        }
        for (Subpopulation sp : this.snvSiblingOfCNV) {
            x = sp.getAbsoluteDeviation() + sp.getSibling().getAbsoluteDeviation();
            value = 1.0 / (x * (sp.getRoot().eventsTo(sp) + sp.getRoot().eventsTo(sp.getSibling())));
            if (d.containsKey(sp)) {
                value += ((Double)d.get(sp)).doubleValue();
            }
            d.put(sp, value);
        }
        return d;
    }
}

