% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{extract_wc_x}
\alias{extract_wc_x}
\title{Extract worst case x value}
\usage{
extract_wc_x(l1, l2)
}
\arguments{
\item{l1}{A list of matrices of \eqn{x} values or a list of lists of one
element being a numeric vector. The list must have three elements named
\code{"cics"}, \code{"dics"} and \code{"dids"}.}

\item{l2}{A list of vectors of indices which specify the worst case elements.
The list must have three elements named \code{"cics"}, \code{"dics"} and
\code{"dids"}. The length of \code{l2} must be equal to the length of
\code{l1} and the length of the vectors of \code{l2} must be equal to the
number of rows of the matrices in \code{l1}.}
}
\value{
A matrix of the worst case values with the number of rows
corresponding to the length of the vectors in \code{l2} and the number of
columns corresponding to the length of \code{l1} or \code{l2} is returned.
}
\description{
The function \code{extract_wc_x()} extracts the worst case \eqn{x} value
from a list of matrices of possible \eqn{x} values based on a list of
vectors of indices which specify the worst case elements.
}
\details{
Information from a list of matrices of values or list of list of
one vector by aid of a list of vectors of indices which specify which
elements in row of each matrix or which elements of the vectors are the
worst case elements.
}
\keyword{internal}
