% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explore}
\alias{explore}
\title{Explore a dataset or variable}
\usage{
explore(data, var, var2, target, split, min_val = NA, max_val = NA,
  auto_scale = TRUE, na = NA, ...)
}
\arguments{
\item{data}{A dataset}

\item{var}{A variable}

\item{var2}{A variable for checking correlation}

\item{target}{Target variable (0/1 or FALSE/TRUE)}

\item{split}{Split by target variable (FALSE/TRUE)}

\item{min_val}{All values < min_val are converted to min_val}

\item{max_val}{All values > max_val are converted to max_val}

\item{auto_scale}{Use 0.2 and 0.98 quantile for min_val and max_val (if min_val and max_val are not defined)}

\item{na}{Value to replace NA}

\item{...}{Further arguments (like flip = TRUE/FALSE)}
}
\value{
Plot object
}
\description{
Explore a dataset or variable
}
\examples{
## Launch Shiny app (in interactive R sessions)
if (interactive())  {
   explore(iris)
}

## Explore grafically

# Load library
library(magrittr)

# Explore a variable
iris \%>\% explore(Species)
iris \%>\% explore(Sepal.Length)
iris \%>\% explore(Sepal.Length, min_val = 4, max_val = 7)

# Explore a variable with a target
iris$is_virginica <- ifelse(iris$Species == "virginica", 1, 0)
iris \%>\% explore(Species, target = is_virginica)
iris \%>\% explore(Sepal.Length, target = is_virginica)

# Explore correlation between two variables
iris \%>\% explore(Species, Petal.Length)
iris \%>\% explore(Sepal.Length, Petal.Length)

# Explore correlation between two variables and split by target
iris \%>\% explore(Sepal.Length, Petal.Length, target = is_virginica)

}
