% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{create_fake_data}
\alias{create_fake_data}
\title{Create fake data}
\usage{
create_fake_data(
  obs = 1000,
  target_name = "target_ind",
  factorise_target = FALSE,
  target1_prob = 0.5,
  add_extreme = TRUE,
  flip_gender = FALSE,
  add_id = FALSE,
  seed = 123
)
}
\arguments{
\item{obs}{Number of observations}

\item{target_name}{Variable name of target}

\item{factorise_target}{Should target variable be factorised?
(from 0/1 to facotr no/yes)?}

\item{target1_prob}{Probability that buy = 1}

\item{add_extreme}{Add an obervation with extreme values?}

\item{flip_gender}{Should Male/Female be flipped in data?}

\item{add_id}{Add an id-variable to data?}

\item{seed}{Seed for randomization}
}
\value{
A dataframe
}
\description{
Fake data that can be used for unit-testing or demonstration
}
\details{
Variables in dataset:
\itemize{
\item id = Identifier
\item period = Year & Month (YYYYMM)
\item city_ind = Indicating if customer is residing in a city (1 = yes, 0 = no)
\item female_ind = Gender of customer is female (1 = yes, 0 = no)
\item fixedvoice_ind = Customer has a fixed voice product (1 = yes, 0 = no)
\item fixeddata_ind = Customer has a fixed data product (1 = yes, 0 = no)
\item fixedtv_ind = Customer has a fixed tv product (1 = yes, 0 = no)
\item mobilevoice_ind = Customer has a mobile voice product (1 = yes, 0 = no)
\item mobiledata_ind = Customer has a mobile data product (1 = yes, 0 = no)
\item bbi_speed_ind = Customer has a Broadband Internet (BBI) with speed
\item bbi_usg_gb = Broadband Internet (BBI) usage in Gigabyte (GB) last month
\item hh_single = Expected to be a Single Household (1 = yes, 0 = no)
}

Target in dataset:
\itemize{
\item target_ind (may be renamed) = Did customer buy a new product in next month?
(1 = yes, 0 = no)
}
}
