% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powoSpDist.R
\name{powoSpDist}
\alias{powoSpDist}
\title{Extract distribution of any plant species}
\usage{
powoSpDist(family,
           species = NULL,
           verbose = TRUE,
           save = FALSE,
           dir = "results_powoSpDist",
           filename = "output")
}
\arguments{
\item{family}{Either one family name or a vector of multiple families
that is present in POWO.}

\item{species}{Either one non-hybrid species name or a vector of multiple
species that is present in POWO. If any species name is not provided, then
the function will search any species from all accepted genera known for the
target family.}

\item{verbose}{Logical, if \code{FALSE}, a message showing each step during
the POWO search will not be printed in the console in full.}

\item{save}{Logical, if \code{TRUE}, the search results will be saved on disk.}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results_powoSpDist} and the search results
will be saved within a subfolder named after the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{output}.}
}
\value{
A table with the following fields: family, genus, species,
taxon_name, authors, scientific_name, native_to_country (original
distribution according to political country),
native_to_botanical_countries (original distribution according to botanical
country), introduced_to_country (exotic distribution according to political
country), introduced_to_botanical_countries (exotic distribution according to
botanical country), kew_id (each species code within Kew's databases),
powo_uri (URI to access each species in POWO).
}
\description{
Produces a CSV file listing the geographical distribution at
country and botanical subdivisions of all target species of vascular plants
at \href{https://powo.science.kew.org/}{Plants of the World Online (POWO)}.
}
\examples{
\dontrun{
library(expowo)

powoSpDist(family = "Lecythidaceae",
           species = "Lecythis pisonis",
           save = FALSE,
           dir = "results_powoSpDist",
           filename = "L_pisonis_distribution")
}

}
\seealso{
\code{\link{POWOcodes}}
}
\author{
Debora Zuanny & Domingos Cardoso
}
