% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify}
\alias{modify}
\alias{modify_if}
\title{Modify data.frame/conditionally modify data.frame}
\usage{
modify(data, expr)

modify_if(data, cond, expr)
}
\arguments{
\item{data}{data.frame}

\item{expr}{expression(s) that should be evaluated in the context of data.frame \code{data}}

\item{cond}{logical vector or expression. Expression will be evaluated in the context of the data.}
}
\value{
Both functions returns modified data.frame
}
\description{
\code{modify} evaluates expression \code{expr} in the context of data.frame 
\code{data}. It works similar to \code{\link[base]{within}} in base R but try
to return new variables in order of their appearance in the expression.
\code{modify_if} modifies only rows for which \code{cond} has TRUE. Other 
rows remain unchanged. Newly created variables also will have values only in 
rows for which \code{cond} has TRUE. There will be NA's in other rows. This 
function tries to mimic SPSS "DO IF(). ... END IF." statement. There is a 
special constant \code{.n} which equals to number of cases in \code{data} for
usage in expression inside \code{modify}. Inside \code{modify_if} \code{.n} 
gives number of rows which will be affected by expressions. Inside these 
functions you can use \code{set} function which creates variables with given
name/set values to existing variables - \link{.set}. It is possible with
\code{set} to assign values to multiple variables at once.
}
\examples{
dfs = data.frame(
    test = 1:5,
    aa = rep(10, 5),
    b_ = rep(20, 5),
    b_1 = rep(11, 5),
    b_2 = rep(12, 5),
    b_3 = rep(13, 5),
    b_4 = rep(14, 5),
    b_5 = rep(15, 5) 
)


# calculate sum of b* variables
modify(dfs, {
    b_total = sum_row(b_, b_1 \%to\% b_5)
    var_lab(b_total) = "Sum of b"
    random_numbers = runif(.n) # .n usage
})

# 'set' function
# new variables filled with NA
modify(dfs, {
    set('new_b`1:5`')
})

# 'set' function
# set values to existing/new variables
# expression in backticks will be expanded - see ?subst
modify(dfs, {
    set('new_b`1:5`', b_1 \%to\% b_5)
})


# conditional modification
modify_if(dfs, test \%in\% 2:4, {
    aa = aa + 1    
    a_b = aa + b_    
    b_total = sum_row(b_, b_1 \%to\% b_5)
    random_numbers = runif(.n) # .n usage
})

}

