% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f.R
\name{f}
\alias{f}
\title{Convert labelled variable to factor}
\usage{
f(x, ...)
}
\arguments{
\item{x}{a vector of data with labels.}

\item{...}{optional arguments for \code{\link[base]{factor}}}
}
\value{
an object of class factor. For details see base \code{factor} documentation.
}
\description{
\code{f} converts labelled variable to factor. Factor levels are constructed
as values labels. If label doesn't exist for particular value then this value
remain as is - so there is no information lost. This levels look like as
"Variable_label|Value label". If variable doesn't have labels then usual
\code{factor} will be applied.
}
\examples{
data(mtcars)

var_lab(mtcars$am) = "Transmission"
val_lab(mtcars$am) = c(automatic = 0, manual=1)

\dontrun{
plot(f(mtcars$am))
}

table(f(mtcars$am))

summary(lm(mpg ~ am, data = mtcars)) # no labels  
summary(lm(mpg ~ f(am), data = mtcars)) # with labels 
summary(lm(mpg ~ f(unvr(am)), data = mtcars)) # without variable label 
}
\seealso{
\link{values2labels}, \link{names2labels}, \link{val_lab}, 
  \link{var_lab}. Materials for base functions: \code{\link[base]{factor}},
  \code{\link[base]{as.factor}}, \code{\link[base]{ordered}},
  \code{\link[base]{as.ordered}}
}

