% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechet-distribution.R
\name{Frechet}
\alias{Frechet}
\alias{dfrechet}
\alias{pfrechet}
\alias{qfrechet}
\alias{rfrechet}
\title{Frechet distribution}
\usage{
dfrechet(x, lambda = 1, mu = 0, sigma = 1, log = FALSE)

pfrechet(q, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qfrechet(p, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

rfrechet(n, lambda = 1, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda, sigma, mu}{shape, scale, and location parameters.
Scale and shape must be positive.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Frechet distribution.
}
\details{
Probability density function
\deqn{
f(x) = \frac{\lambda}{\sigma} z^{-1-\lambda} \exp(-z^{-\lambda})
}{
f(x) = \lambda/\sigma * z^{-1-\lambda} * exp(-z^-\lambda)
}

Cumulative distribution function
\deqn{
F(x) = \exp(-z^{-\lambda})
}{
F(x) = exp(-z^-\lambda)
}

Quantile function
\deqn{
F^{-1}(p) = \mu + \sigma -\log(p)^{-1/\lambda}
}{
F^-1(p) = \mu + \sigma * -log(p)^{-1/\lambda}
}

where \eqn{ z = \frac{x-\mu}{\sigma} }{ z = (x-\mu)/\sigma }.
}
\examples{

x <- rfrechet(1e5, 5, 2, 1.5)
xx <- seq(0, 1000, by = 0.1)
hist(x, 200, freq = FALSE)
lines(xx, dfrechet(xx, 5, 2, 1.5), col = "red") 
hist(pfrechet(x, 5, 2, 1.5))
plot(ecdf(x))
lines(xx, pfrechet(xx, 5, 2, 1.5), col = "red", lwd = 2)

}
\references{
Bury, K. (1999). Statistical Distributions in Engineering.
Cambridge University Press.
}
\keyword{distribution}

