
test_that("All probabilities/densities >= 0", {

  x <- c(-Inf, -100, -10, -5, -1, -0.5, 0, 0.5, 1, 5, 10, 100, Inf)
  
  expect_true(suppressWarnings(all(dbbinom(x, 1, 1, 1) >= 0)))
  expect_true(suppressWarnings(all(dbern(x, 0.5) >= 0)))
  expect_true(suppressWarnings(all(dbetapr(x, 1, 1, 1) >= 0)))
  expect_true(all(dbhatt(x, sigma = 1) >= 0))
  expect_true(suppressWarnings(all(dbnbinom(x, 1, 1, 1) >= 0)))
  expect_true(all(dbvnorm(x, x, sd1 = 1) >= 0))
  expect_true(suppressWarnings(all(dbvpois(x, x, 1, 1, 1) >= 0)))
  expect_true(suppressWarnings(all(dcat(x, c(0.5, 0.5)) >= 0)))
  expect_true(all(ddirichlet(c(0.5, 0.5), c(1, 0.5)) >= 0))
  expect_true(suppressWarnings(all(ddlaplace(x, 0, scale = 0.5) >= 0)))
  expect_true(suppressWarnings(all(ddnorm(x, sd = 1) >= 0)))
  expect_true(suppressWarnings(all(ddgamma(x, 9, 1) >= 0)))
  expect_true(suppressWarnings(all(ddunif(x, min = 10, max = 100) >= 0)))
  expect_true(suppressWarnings(all(ddweibull(x, 0.5, 1) >= 0)))
  expect_true(all(dfatigue(x, 1, 1) >= 0))
  expect_true(all(dfrechet(x, lambda = 1) >= 0))
  expect_true(all(dgev(x, 1, 1, 1) >= 0))
  expect_true(all(dgompertz(x, 1, 1) >= 0))
  expect_true(all(dgpd(x, 1, 1, 1) >= 0))
  expect_true(suppressWarnings(all(dgpois(x, 1, 1) >= 0)))
  expect_true(all(dgumbel(x, sigma = 1) >= 0))
  expect_true(all(dhcauchy(x, 1) >= 0))
  expect_true(all(dhnorm(x, 1) >= 0))
  expect_true(all(dht(x, 5, 1) >= 0))
  expect_true(all(dhuber(x, 0, 1, 1) >= 0))
  expect_true(all(dinvgamma(x, 1, 1) >= 0))
  expect_true(all(dinvchisq(x, 1, 1) >= 0))
  expect_true(all(dkumar(x, 1, 1) >= 0))
  expect_true(all(dlaplace(x, 0, 1) >= 0))
  expect_true(suppressWarnings(all(dlgser(x, 0.5) >= 0)))
  expect_true(all(dlomax(x, 1, 1) >= 0))
  expect_true(all(dmixnorm(x, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3)) >= 0))
  expect_true(suppressWarnings(all(dmixpois(x, c(1,2,3), c(1/3,1/3,1/3)) >= 0)))
  expect_true(suppressWarnings(all(dnhyper(x, 60, 35, 15) >= 0)))
  # expect_true(all(ddirmnom(c(1, 1, 1), 2, c(1, 1, 1)) >= 0))
  # expect_true(all(dmnom(c(1, 1, 1), 2, c(1/3, 1/3, 1/3)) >= 0))
  # expect_true(all(dmvhyper(c(1, 2, 2), c(2,3,4), 5) >= 0))
  expect_true(all(dnsbeta(x, 1, 1, -2, 2) >= 0))
  expect_true(all(dlst(x, 2, 0, 1) >= 0))
  expect_true(all(dpareto(x, 1, 1) >= 0))
  expect_true(all(dprop(x, 10, 0.5) >= 0))
  expect_true(all(drayleigh(x, 1) >= 0))
  expect_true(suppressWarnings(all(dskellam(x, 1, 1) >= 0)))
  expect_true(all(dsgomp(x, 0.4, 1) >= 0))
  expect_true(all(dslash(x, sigma = 1) >= 0))
  expect_true(all(dtnorm(x, 0, 1, 1, 2) >= 0))
  expect_true(suppressWarnings(all(dtpois(x, lambda = 25, a = 0) >= 0)))
  expect_true(suppressWarnings(all(dtbinom(x, 100, 0.67, a = 60, b = 70) >= 0)))
  expect_true(all(dtriang(x, 1, 2, 1.5) >= 0))
  expect_true(all(dwald(x, 1, 1) >= 0))
  expect_true(suppressWarnings(all(dzip(x, 1, 0.5) >= 0)))
  expect_true(suppressWarnings(all(dzib(x, 1, 0.5, 0.5) >= 0)))
  expect_true(suppressWarnings(all(dzinb(x, 1, 0.5, 0.5) >= 0)))
  
})




test_that("All cumulative probabilities >= 0 and <= 1", {
  
  x <- c(-Inf, -100, -10, -5, -1, -0.5, 0, 0.5, 1, 5, 10, 100, Inf)
  
  expect_true(all(pbbinom(x, 1, 1, 1) >= 0 & pbbinom(x, 1, 1, 1) <= 1))
  expect_true(all(pbern(x, 0.5) >= 0 & pbern(x, 0.5) <= 1))
  expect_true(all(pbetapr(x, 1, 1, 1) >= 0 & pbetapr(x, 1, 1, 1) <= 1))
  expect_true(all(pbhatt(x, sigma = 1) >= 0 & pbhatt(x, sigma = 1) <= 1))
  expect_true(all(pbnbinom(x, 1, 1, 1) >= 0 & pbnbinom(x, 1, 1, 1) <= 1))
  # expect_true(all(pbvnorm(x, x, sd1 = 1) >= 0))
  # expect_true(all(pbvpois(x, x, 1, 1, 1) >= 0))
  expect_true(all(pcat(x, c(0.5, 0.5)) >= 0 & pcat(x, c(0.5, 0.5)) <= 1))
  # expect_true(all(pdirichlet(c(0.5, 0.5), c(1, 0.5)) >= 0))
  expect_true(all(pdlaplace(x, 0, scale = 0.5) >= 0 & pdlaplace(x, 0, scale = 0.5) <= 1))
  expect_true(all(pdnorm(x, sd = 50) >= 0 & pdnorm(x, sd = 50) <= 1))
  expect_true(all(pdgamma(x, 9, 1) >= 0 & pdgamma(x, 9, 1) <= 1))
  expect_true(all(pdunif(x, min = 10, max = 100) >= 0 & pdunif(x, min = 10, max = 100) <= 1))
  expect_true(all(pdweibull(x, 0.5, 1) >= 0 & pdweibull(x, 0.5, 1) <= 1))
  expect_true(all(pfatigue(x, 1, 1) >= 0 & pfatigue(x, 1, 1) <= 1))
  expect_true(all(pfrechet(x, lambda = 1) >= 0 & pfrechet(x, lambda = 1) <= 1))
  expect_true(all(pgev(x, 1, 1, 1) >= 0 & pgev(x, 1, 1, 1) <= 1))
  expect_true(all(pgompertz(x, 1, 1) >= 0 & pgompertz(x, 1, 1) <= 1))
  expect_true(all(pgpd(x, 1, 1, 1) >= 0 & pgpd(x, 1, 1, 1) <= 1))
  expect_true(all(pgpois(x, 1, 1) >= 0 & pgpois(x, 1, 1) <= 1))
  expect_true(all(pgumbel(x, sigma = 1) >= 0 & pgumbel(x, sigma = 1) <= 1))
  expect_true(all(phcauchy(x, 1) >= 0 & phcauchy(x, 1) <= 1))
  expect_true(all(phnorm(x, 1) >= 0 & phnorm(x, 1) <= 1))
  expect_true(all(pht(x, 5, 1) >= 0 & pht(x, 5, 1) <= 1))
  expect_true(all(phuber(x, 0, 1, 1) >= 0 & phuber(x, 0, 1, 1) <= 1))
  expect_true(all(pinvgamma(x, 1, 1) >= 0 & pinvgamma(x, 1, 1) <= 1))
  expect_true(all(pinvchisq(x, 1, 1) >= 0 & pinvchisq(x, 1, 1) <= 1))
  expect_true(all(pkumar(x, 1, 1) >= 0 & pkumar(x, 1, 1) <= 1))
  expect_true(all(plaplace(x, 0, 1) >= 0 & plaplace(x, 0, 1) <= 1))
  expect_true(all(plgser(x, 0.5) >= 0 & plgser(x, 0.5) <= 1))
  expect_true(all(plomax(x, 1, 1) >= 0 & plomax(x, 1, 1) <= 1))
  expect_true(all(pmixnorm(x, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3)) >= 0 & pmixnorm(x, c(1,2,3), c(1,2,3), c(1/3,1/3,1/3)) <= 1))
  expect_true(all(pmixpois(x, c(1,2,3), c(1/3,1/3,1/3)) >= 0 & pmixpois(x, c(1,2,3), c(1/3,1/3,1/3)) <= 1))
  expect_true(all(pnhyper(x, 60, 35, 15) >= 0 & pnhyper(x, 60, 35, 15) <= 1))
  # expect_true(all(pdirmnom(c(1, 1, 1), 2, c(1, 1, 1)) >= 0))
  # expect_true(all(pmnom(c(1, 1, 1), 2, c(1/3, 1/3, 1/3)) >= 0))
  # expect_true(all(pmvhyper(c(1, 2, 2), c(2,3,4), 5) >= 0))
  expect_true(all(pnsbeta(x, 1, 1, -2, 2) >= 0 & pnsbeta(x, 1, 1, -2, 2) <= 1))
  expect_true(all(plst(x, 2, 0, 1) >= 0 & plst(x, 2, 0, 1) <= 1))
  expect_true(all(ppareto(x, 1, 1) >= 0 & ppareto(x, 1, 1) <= 1))
  expect_true(all(pprop(x, 10, 0.5) >= 0 & pprop(x, 10, 0.5) <= 1))
  expect_true(all(prayleigh(x, 1) >= 0 & prayleigh(x, 1) <= 1))
  # expect_true(all(pskellam(x, 1, 1) >= 0))
  expect_true(all(psgomp(x, 0.4, 1) >= 0 & psgomp(x, 0.4, 1) <= 1))
  expect_true(all(pslash(x, sigma = 1) >= 0 & pslash(x, sigma = 1) <= 1))
  expect_true(all(ptnorm(x, 0, 1, 1, 2) >= 0 & ptnorm(x, 0, 1, 1, 2) <= 1))
  expect_true(all(ptpois(x, lambda = 25, a = 0) >= 0 & ptpois(x, lambda = 25, a = 0) <= 1))
  expect_true(all(ptbinom(x, 100, 0.67, 60, 70) >= 0 & ptbinom(x, 100, 0.67, 60, 70) <= 1))
  expect_true(all(ptbinom(x, 100, 0.67, a = 60, b = 70) >= 0 & ptbinom(x, 100, 0.67, a = 60, b = 70) <= 1))
  expect_true(all(ptriang(x, 1, 2, 1.5) >= 0 & ptriang(x, 1, 2, 1.5) <= 1))
  expect_true(all(pwald(x, 1, 1) >= 0 & pwald(x, 1, 1) <= 1))
  expect_true(all(pzip(x, 1, 0.5) >= 0 & pzip(x, 1, 0.5) <= 1))
  expect_true(all(pzib(x, 1, 0.5, 0.5) >= 0 & pzib(x, 1, 0.5, 0.5) <= 1))
  expect_true(all(pzinb(x, 1, 0.5, 0.5) >= 0 & pzinb(x, 1, 0.5, 0.5) <= 1))
  
})


