% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/independent_twoway_generation.R
\name{twoway_simulation_independent}
\alias{twoway_simulation_independent}
\title{Simulate independent measurements in a two-way factorial design}
\usage{
twoway_simulation_independent(
  group_size,
  matrices_obj,
  distribution = "normal",
  skewness = 1,
  inferior_limit = -Inf,
  superior_limit = Inf,
  balanced = TRUE,
  nsims = 200
)
}
\arguments{
\item{group_size}{Integer or matrix - Sample size for each group (combination of factor levels). If 'balanced=TRUE' (default) 'group_size' must be an integer. If 'balanced=FALSE' 'group_size' must be a matrix.}

\item{matrices_obj}{List - Output generated by 'calculate_mean_matrix' that include cell mean and standard deviation matrices.}

\item{distribution}{Character - Type of distribution to simulate. Possible values are 'normal', 'skewed' or 'truncated.normal'.}

\item{skewness}{Numeric - Momentum of distribution skewness}

\item{inferior_limit}{Numeric - Value of the lower bound for the truncated distribution, defaults to '-Inf'. Ignored if 'distribution' is either 'normal' or 'skewed'.}

\item{superior_limit}{Numeric - Value of the upper bound for the truncated distribution, defaults to 'Inf'. Ignored if 'distribution' is either 'normal' or 'skewed'.}

\item{balanced}{Logical - Whether the study will be performed with the same number of subjects in all groups. Default is 'TRUE'. See 'details'.}

\item{nsims}{Integer - Number of iterations.}
}
\value{
data.frame with modeled outcome values, factor level labels, iteration number and sample size.
}
\description{
Both regular and internal function.
As regular function takes input generated by the 'calculate_mean_matrix' function and iteratively simulates independent measures two-way factorial experiments.
Outcome may be normally distributed, hava a skewed normal distribution or a truncated normal distribution.
}
\details{
As internal function runs with a single iteration inside 'graph_twoway_assumptions', which in itself is inside  'calculate_mean_matrix' to generate data for the cell mean and standard deviation plot.

For unbalanced independent measures designs, this function generates a simulation with 'max(group_size)' for all combinations of factors and then eliminates observations
at random in those factor combinations that have less participants or study subjects. This may not sound like the most efficient way to proceed, is quite fast anyhow.
The 'n' column in the output will reflect how many observations each factor combination has. This should match the input matrix.
}
\examples{
refmean <- 1
treatgroups <- 4
timepoints <- 5
treateff <- 1.5
timeeff <- 0.85
factors_levels_names <- list(treatment=letters[1:treatgroups], time=1:timepoints)

## Independent design
effects_treat_time <- calculate_mean_matrix(refmean = refmean,
                                            fAeffect = treateff, fBeffect = timeeff,
                                            nlfA = treatgroups, nlfB = timepoints,
                                            label_list = factors_levels_names)
## Inspect plot to check if matrices correspond to design
n <- 20
independent_experiment <- twoway_simulation_independent(group_size = n,
                                                        matrices_obj = effects_treat_time)
head(independent_experiment, 10)

}
