% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_names.R
\name{col_names}
\alias{col_names}
\alias{col_names<-}
\title{Retrieve/Set column names}
\usage{
col_names(x, ...)

col_names(x) <- value
}
\arguments{
\item{x}{An object of class \code{\link[=radf]{radf()}}}

\item{...}{Further arguments passed to methods.}

\item{value}{An ordered vector of the same length as the `index' attribute of x.}
}
\description{
Retrieve or set the column names of a class \code{\link[=radf]{radf()}} object. Similar to \code{colnames}, with the only
difference that \code{col_names} is for \code{\link[=radf]{radf()}} objects.
}
\examples{
\dontrun{
# Simulate bubble processes
dta <- data.frame(psy1 = sim_psy1(n = 100), psy2 = sim_psy2(n = 100))

rfd <- radf(dta)
col_names(rfd) <- c("OneBubble", "TwoBubbles")
}
}
