% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_va_exgr.R
\name{get_va_exgr}
\alias{get_va_exgr}
\title{Detailed origin and destination of value added in gross exports}
\usage{
get_va_exgr(
  wio_object,
  va_type = "FC",
  geo_orig = "all",
  sec_orig = "TOTAL",
  geo_export,
  sec_export = "TOTAL",
  as_numeric = TRUE
)
}
\arguments{
\item{wio_object}{An object of class \code{wio}.}

\item{va_type}{Character string specifying the output as domestic
content (\code{"DC"}), foreign content (\code{"FC"}) or total
content (\code{"TC"}) from the perspective of the exporter.
As origin of value added is specified, this is normally redundant, but in
the case of exporter \code{"WLD"}, the domestic and foreign content is
considered as the sum of domestic/foreign contents of all individual
countries. For groups (such as \code{"EU27"}) domestic/foreign means value
added from within/outside the group.}

\item{geo_orig}{Character string with code of country or country group
of origin of value added}

\item{sec_orig}{Character string with code of sector or sector group
of origin of value added. Combinations (with \code{"|"}) and exceptions
(with \code{"x"}) are allowed.}

\item{geo_export}{Character string with code of exporting country or
country group.}

\item{sec_export}{Character string with code of exporting sector or
sector group. Combinations (with \code{"|"}) and exceptions (with \code{"x"})
are allowed.}

\item{as_numeric}{Boolean specifying whether to return a numeric value or
matrix (\code{TRUE}, default) or a data frame (default for
\code{\link[=get_data]{get_data()}}).}
}
\value{
A matrix, vector or data frame with export value added data.
}
\description{
Origin of value added in gross exports. It combines a
\code{\link[=make_exvadir]{make_exvadir()}} command and a \code{\link[=get_data]{get_data()}} command to obtain
a result equivalent to the OECD's Origin of Value added in Gross Exports
\code{EXGR_BSCI}, but with much more flexible geographical and sector options.
}
\examples{
wio <- make_wio("iciotest")
# Exports of manufactures of Spain using foreign VA from France
get_va_exgr(wio, "FC", "FRA", "TOTAL", "ESP", "MANUF")
}
