% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{read_edf_file}
\alias{read_edf_file}
\title{Internal function that reads EDF file}
\usage{
read_edf_file(
  filename,
  consistency,
  import_events,
  import_recordings,
  import_samples,
  sample_attr_flag,
  start_marker_string,
  end_marker_string,
  verbose
)
}
\arguments{
\item{verbose, }{whether to show progressbar and report number of trials}

\item{int}{consistency, consistency check control (for the time stamps of the start
and end events, etc). 0, no consistency check. 1, check consistency and report.
2, check consistency and fix.}

\item{bool}{import_samples, load/skip loading of samples.}

\item{LogicalVector}{sample_attr_flag, boolean vector that indicates which sample fields are to be stored}

\item{std::string}{end_marker_string, event that marks trial end}
}
\value{
List, contents of the EDF file. Please see read_edf for details.
}
\description{
Reads EDF file into a list that contains events, samples, and recordings.
DO NOT call this function directly. Instead, use read_edf function that implements
parameter checks and additional postprocessing.
}
\keyword{internal}
