% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{\%In\%}
\alias{\%In\%}
\title{Find if value belongs to a set of intervals}
\usage{
x \%In\% Intv
}
\arguments{
\item{x}{A set of numeric values}

\item{Intv}{A set of intervals, defined by a two-column matrix of endpoints or an Intervals
object}
}
\value{
A vector of logicals, which are true if x[i] belongs to any of the intervals in the set.
}
\description{
Wrapper around \code{\link[intervals]{distance_to_nearest}} from the "intervals" package.
}
\examples{
start <- c(0, 1, 2)
end <- c(.5, 1.3, 3)
intv <- cbind(start, end) # The first interval is 0-0.5, second is 1-1.3, etc.
c(0, .6, 1.5, 3) \%In\% intv
}
\author{
Simon Barthelme
}
