% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-bidsify.R
\name{run_bidsify}
\alias{run_bidsify}
\title{Internal function to run bidsify on a single eye}
\usage{
run_bidsify(
  eyeris,
  save_all = TRUE,
  epochs_list = NULL,
  bids_dir = NULL,
  participant_id = NULL,
  session_num = NULL,
  task_name = NULL,
  run_num = NULL,
  save_raw = TRUE,
  html_report = TRUE,
  report_seed = 0,
  report_epoch_grouping_var_col = "matched_event",
  eye_suffix = NULL,
  verbose = TRUE,
  csv_enabled = TRUE,
  db_enabled = FALSE,
  db_path = "my-project",
  parallel_processing = FALSE,
  raw_binocular_object = NULL,
  skip_db_cleanup = FALSE
)
}
\arguments{
\item{eyeris}{An \code{eyeris} object}

\item{save_all}{Whether to save all data}

\item{epochs_list}{A list of epochs to include}

\item{bids_dir}{The directory to save the bids data}

\item{participant_id}{The participant id}

\item{session_num}{The session number}

\item{task_name}{The task name}

\item{run_num}{The run number}

\item{save_raw}{Whether to save raw data}

\item{html_report}{Whether to generate an html report}

\item{report_seed}{The seed for the report}

\item{report_epoch_grouping_var_col}{The column to use for grouping epochs in the report}

\item{eye_suffix}{The suffix to add to the eye data}

\item{verbose}{Whether to print verbose output}

\item{csv_enabled}{Whether to save csv files}

\item{db_enabled}{Whether to save data to the database}

\item{db_path}{The path to the database}

\item{parallel_processing}{Whether to enable parallel database processing}

\item{raw_binocular_object}{The raw binocular object}

\item{skip_db_cleanup}{Whether to skip database cleanup, used internally to avoid unintended overwriting when calling complementary binocular bidsify processing commands}
}
\value{
An \code{eyeris} object
}
\description{
Internal function to run bidsify on a single eye
}
\keyword{internal}
