% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{setup_fastf1}
\alias{setup_fastf1}
\title{Setup fastf1 connection}
\usage{
setup_fastf1(
  ...,
  envname = "f1dataR_env",
  new_env = identical(envname, "f1dataR_env")
)
}
\arguments{
\item{...}{Additional parameters to pass to \link[reticulate]{py_install}}

\item{envname}{Optionally pass an environment name used. Defaults to package default of \code{f1dataR_env}.}

\item{new_env}{Whether or not to completely remove and recreate the environment provided in \code{envname}. This will fix
any issues experienced by \code{fastf1} related to package dependencies.}
}
\value{
No return value, called to install or update \code{fastf1} Python package.
}
\description{
Installs or optionally updates \code{fastf1} Python package in the current active Python
environment/virtualenv/conda env.

More information on how to manage complex environment needs can be read in the
\href{https://rstudio.github.io/reticulate/articles/python_dependencies.html}{reticulate docs}, and tools for
managing virtual environments are documented in  \link[reticulate]{virtualenv-tools} and
\link[reticulate]{conda-tools}
}
\examples{
\dontrun{
# Install fastf1 into the currently active Python environment
setup_fastf1()

# Reinstall fastf1 and recreate the environment.
setup_fastf1(envname = "f1dataR_env", new_env = TRUE)
}
}
