% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_bptf.R
\name{fsl_bptf}
\alias{fsl_bptf}
\title{\code{bptf} function from FSL}
\usage{
fsl_bptf(orig_data, HP_sigma = 2000)
}
\arguments{
\item{orig_data}{\eqn{T} by \eqn{V} data matrix whose columns will be detrended}

\item{HP_sigma}{The frequency parameter for the highpass filter}
}
\value{
The data with detrended columns
}
\description{
Copy of highpass filter as implemented by \code{bptf} in FSL. The results are very
similar but not identical.
}
\details{
Sources:
https://cpb-us-w2.wpmucdn.com/sites.udel.edu/dist/7/4542/files/2016/09/fsl_temporal_filt-15sywxn.m
https://github.com/rordenlab/niimath/blob/master/src/core32.c
}
\section{References}{

\itemize{
\item{Jenkinson, M., Beckmann, C. F., Behrens, T. E. J., Woolrich, M. W. & Smith, S. M. FSL. NeuroImage 62, 782-790 (2012).}
}
}

\examples{
fsl_bptf(matrix(rnorm(700), nrow=100))
}
