% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{residuals.TSLM}
\alias{residuals.TSLM}
\title{Extract residuals from a fable model}
\usage{
\method{residuals}{TSLM}(object, ...)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{...}{Additional arguments for forecast model methods.}
}
\value{
A vector of fitted residuals.
}
\description{
Extracts the residuals.
}
\examples{
as_tsibble(USAccDeaths) \%>\%
  model(lm = TSLM(log(value) ~ trend() + season())) \%>\%
  residuals()
}
