% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnetar.R
\name{forecast.NNETAR}
\alias{forecast.NNETAR}
\title{Forecast a model from the fable package}
\usage{
\method{forecast}{NNETAR}(
  object,
  new_data,
  specials = NULL,
  simulate = TRUE,
  bootstrap = FALSE,
  times = 5000,
  ...
)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{new_data}{A tsibble containing the time points and exogenous regressors to produce forecasts for.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{simulate}{If \code{TRUE}, forecast distributions are produced by sampling from a normal distribution. Without simulation, forecast uncertainty cannot be estimated for this model and instead a degenerate distribution with the forecast mean will be produced.}

\item{bootstrap}{If \code{TRUE}, forecast distributions are produced by sampling from the model's training residuals.}

\item{times}{The number of sample paths to use in producing the forecast distribution. Setting \code{simulate = FALSE} or \code{times = 0} will produce degenerate forecast distributions of the forecast mean.}

\item{...}{Other arguments passed to methods}
}
\value{
A list of forecasts.
}
\description{
Produces forecasts from a trained model.
}
\examples{
as_tsibble(airmiles) \%>\%
  model(nn = NNETAR(box_cox(value, 0.15))) \%>\%
  forecast(times = 10)
}
