% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom.R
\name{glance.mdl_df}
\alias{glance.mdl_df}
\alias{glance.mdl_ts}
\title{Glance a mable}
\usage{
\method{glance}{mdl_df}(x, ...)

\method{glance}{mdl_ts}(x, ...)
}
\arguments{
\item{x}{A mable.}

\item{...}{Arguments for model methods.}
}
\description{
Uses the models within a mable to produce a one row summary of their fits.
This typically contains information about the residual variance,
information criterion, and other relevant summary statistics. Each model
will be represented with a row of output.
}
\examples{
\dontshow{if (requireNamespace("fable", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(fable)
library(tsibbledata)

olympic_running \%>\%
  model(lm = TSLM(log(Time) ~ trend())) \%>\% 
  glance()
\dontshow{\}) # examplesIf}
}
