% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataParameterChecks.R
\name{.impute_outcome_type}
\alias{.impute_outcome_type}
\title{Internal imputation function for the outcome type.}
\usage{
.impute_outcome_type(
  data,
  outcome_column,
  class_levels,
  censoring_indicator,
  event_indicator,
  competing_risk_indicator
)
}
\arguments{
\item{data}{Data set as loaded using the \code{.load_data} function.}

\item{outcome_column}{Name of the outcome column in the data set.}

\item{class_levels}{User-provided class levels for the outcome.}

\item{censoring_indicator}{Name of censoring indicator.}

\item{event_indicator}{Name of event indicator.}

\item{competing_risk_indicator}{Name of competing risk indicator.}
}
\value{
The imputed outcome type.
}
\description{
This function allows for imputation of the most plausible outcome type.
This imputation is only done for trivial cases, where there is little doubt.
As a consequence \code{count} and \code{continuous} outcome types are never imputed.
}
\note{
It is highly recommended that the user provides the outcome type.
}
\keyword{internal}
