% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarS4Classes.R
\docType{class}
\name{vimpTable-class}
\alias{vimpTable-class}
\title{Variable importance table}
\description{
A vimpTable object contains information concerning variable importance of one
or more features. These objects are created during feature selection.
}
\details{
vimpTable objects exists in various states. These states are
generally incremental, i.e. one cannot turn a declustered table into the
initial version. Some methods such as aggregation internally do some state
reshuffling.

This object replaces the ad-hoc lists with information that were used in
versions prior to familiar 1.2.0.
}
\section{Slots}{

\describe{
\item{\code{vimp_table}}{Table containing features with corresponding scores.}

\item{\code{vimp_method}}{Method used to compute variable importance scores for each
feature.}

\item{\code{run_table}}{Run table for the data used to compute variable importances
from. Used internally.}

\item{\code{score_aggregation}}{Method used to aggregate the score of contrasts for
each categorical feature, if any,}

\item{\code{encoding_table}}{Table used to relate categorical features to their
contrasts, if any. Not used for all variable importance methods.}

\item{\code{cluster_table}}{Table used to relate original features with features
after clustering. Variable importance is determined after feature
processing, which includes clustering.}

\item{\code{invert}}{Determines whether increasing score corresponds to increasing
(\code{FALSE}) or decreasing rank (\code{TRUE}). Used internally to determine how
ranks should be formed.}

\item{\code{project_id}}{Identifier of the project that generated the vimpTable
object.}

\item{\code{familiar_version}}{Version of the familiar package used to create this
table.}

\item{\code{state}}{State of the variable importance table. The object can have the
following states:
\itemize{
\item \code{initial}: initial state, directly after the variable importance table is
filled.
\item \code{decoded}: depending on the variable importance method, the initial
variable importance table may contain the scores of individual contrasts
for categorical variables. When decoded, data in the \code{encoding_table}
attribute has been used to aggregate scores from all contrasts into a
single score for each feature.
\item \code{declustered}: variable importance is determined from fully processed
features, which includes clustering. This means that a single feature in
the variable importance table may represent multiple original features.
When a variable importance table has been declustered, all clusters have
been turned into their constituent features.
\item \code{reclustered}: When the table is reclustered, features are replaced by
their respective clusters. This is actually used when updating the cluster
table to ensure it fits to a local context. This prevents issues when
attempting to aggregate or apply variable importance tables in data with
different feature preprocessing, and as a result, different clusters.
\item \code{ranked}: The scores have been used to create ranks, with lower ranks
indicating better features.
\item \code{aggregated}: Score and ranks from multiple variable importance tables
were aggregated.
}}
}}

\seealso{
\code{\link{get_vimp_table}}, \code{\link{aggregate_vimp_table}}
}
