% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fangs.R
\name{fangs}
\alias{fangs}
\title{Feature Allocation Neighborhood Greedy Search}
\usage{
fangs(
  samples,
  nInit = 16,
  nSweet = 4,
  nIterations = 1000,
  maxSeconds = 60,
  a = 1,
  nCores = 0,
  quiet = FALSE
)
}
\arguments{
\item{samples}{An object of class \sQuote{list} containing posterior samples
from a feature allocation distribution. Each list element encodes one
feature allocation as a binary matrix, with items in the rows and features
in the columns.}

\item{nInit}{The number of initial feature allocations to obtain using the
alignment method.  For each initial feature, a baseline feature allocation
is uniformly selected from the list provided in \code{samples}. Samples are
aligned to the baseline, proportions are computed for each matrix element,
and the initial feature allocation is obtained by thresholding according to
\eqn{a/2}.}

\item{nSweet}{The number of feature allocations among \code{nInit} which are
chosen (by lowest expected loss) to be optimized in the sweetening phase.}

\item{nIterations}{The number of iterations (i.e., proposed changes) to
consider per initial estimate in the sweetening phase, although the actual
number may be less due to the \code{maxSeconds} argument.}

\item{maxSeconds}{Stop the search and return the current best estimate once
the elapsed time in the sweetening phase exceeds this value.}

\item{a}{A numeric scalar for the cost parameter of generalized Hamming
distance used in FARO loss.  The other cost parameter, \eqn{b}, is equal
to \eqn{2 - a}.}

\item{nCores}{The number of CPU cores to use, i.e., the number of
simultaneous calculations at any given time. A value of zero indicates to
use all cores on the system.}

\item{quiet}{If \code{TRUE}, intermediate status reporting is suppressed.}
}
\value{
A list with the following elements:
\itemize{
\item estimate - The feature allocation point estimate in binary matrix form.
\item expectedLoss - The estimated expected FARO loss of the point estimate.
\item iteration - The iteration number (out of \code{nIterations}) at which the point estimate was found while sweetening.
\item nIterations - The number of sweetening iterations performed.
\item secondsInitialization - The elapsed time in the initialization phrase.
\item secondsSweetening - The elapsed time in the sweetening phrase.
\item secondsTotal - The total elapsed time.
\item whichSweet - The proposal number (out of \code{nSweet}) from which the point estimate was found.
\item nInit - The original supplied value of \code{nInit}.
\item nSweet - The original supplied value of \code{nSweet}.
\item a - The original supplied value of \code{a}.
}
}
\description{
An implementation of the feature allocation greedy search algorithm is
provided.
}
\examples{
# To reduce load on CRAN testing servers, limit the number of iterations.
data(samplesFA)
fangs(samplesFA, nIterations=100, nCores=2)

}
