/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jfm.lp.ConstraintBuilder;
import jfm.lp.Matrix;
import jfm.lp.MatrixVariable;
import jfm.lp.SOS2Primitive;
import jfm.model.BadModelException;
import jfm.model.Farm;
import jfm.model.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelComponent {
    private final Set<Types.ObjectiveType> requiredObjectives = new HashSet<Types.ObjectiveType>();
    public final MCType type;
    private Farm parent = null;
    protected SOS2Primitive curve = null;
    private boolean requiresStructureUpdate = true;
    public final Map<ConstraintBuilder.CBType, ConstraintBuilder> constraintBuilders = new LinkedHashMap<ConstraintBuilder.CBType, ConstraintBuilder>();
    protected Matrix matrix = null;

    protected void requireObjective(Types.ObjectiveType objT) {
        this.requiredObjectives.add(objT);
    }

    public Set<Types.ObjectiveType> getRequiredObjectives() {
        return Collections.unmodifiableSet(this.requiredObjectives);
    }

    public abstract void setFormulaVariables();

    public abstract ModelComponent copy();

    public void registerCurve(SOS2Primitive curve_) {
        this.curve = curve_;
    }

    public void addConstraintBuilder(ConstraintBuilder blder) {
        if (blder.associatedWith() != this.type) {
            throw new Error("Constraint builder " + (Object)((Object)blder.type()) + " is not associated with " + (Object)((Object)this.type));
        }
        if (this.constraintBuilders.containsKey((Object)blder.type())) {
            throw new Error("A ConstraintBuilder of type " + (Object)((Object)blder.type()) + " already exists ");
        }
        this.constraintBuilders.put(blder.type(), blder);
    }

    public void removeConstraintBuilder(ConstraintBuilder.CBType cname) {
        if (!this.constraintBuilders.containsKey((Object)cname)) {
            throw new Error("Can't remove " + (Object)((Object)cname) + " because it is already gone");
        }
        this.constraintBuilders.remove((Object)cname);
    }

    public void setParent(Farm parent_) {
        this.parent = parent_;
        this.requireMatrixRebuild();
    }

    public Farm getParent() {
        return this.parent;
    }

    protected abstract void initializeStructure() throws BadModelException;

    protected abstract void updateStructure();

    protected void buildConstraints() {
        for (ConstraintBuilder blder : this.constraintBuilders.values()) {
            blder.build();
        }
    }

    protected ModelComponent(MCType type_) {
        this.type = type_;
    }

    public void registerMatrix(Matrix matrix_) {
        this.matrix = matrix_;
    }

    public void requireStructureUpdate() {
        this.requiresStructureUpdate = true;
    }

    public void structureUpdateDone() {
        this.requiresStructureUpdate = false;
    }

    boolean requiresStructureUpdate() {
        return this.requiresStructureUpdate;
    }

    protected void requireMatrixRebuild() {
        if (this.matrix != null) {
            this.matrix.flagForRebuild();
        }
    }

    void addModifiedVariableToStack(MatrixVariable var) {
        this.matrix.addModifiedVariableToStack(var);
    }

    public String printConstraints(Farm model) {
        return "Not implemented";
    }

    protected abstract String name();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MCType {
        CROPPING,
        ROTATIONS,
        WORKERS,
        STUBBLES,
        CROPCOMPLEXITY,
        FREETIME,
        HEDGEROWS,
        DITCHES,
        WOODLAND,
        LANDUSE,
        MOTADRISK,
        VARRISK,
        ELSOPTIONS,
        ELSBOUNDARIES,
        FIELDMARGINS;

    }
}

