/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jfm.lp.LPPeer;
import jfm.lp.LPX;
import jfm.lp.Matrix;
import jfm.lp.ModelComponent;
import jfm.lp.Objective;
import jfm.model.BadModelException;
import jfm.model.Crop;
import jfm.model.CroppingComponent;
import jfm.model.ELSOption;
import jfm.model.ELSOptionComponent;
import jfm.model.GLPKException;
import jfm.model.LandUseComponent;
import jfm.model.Location;
import jfm.model.RotationsComponent;
import jfm.model.Types;
import jfm.model.WorkersComponent;
import jfm.xml.FarmParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Farm {
    public LandUseComponent landUse;
    public CroppingComponent cropping;
    public RotationsComponent rotations;
    public WorkersComponent workers;
    private static Set<ModelComponent.MCType> compulsoryComponents = new HashSet<ModelComponent.MCType>();
    Set<ModelComponent> components = new LinkedHashSet<ModelComponent>();
    private final Matrix matrix;
    public final int numPeriods;
    public static int maxYears;
    private double fuelPrice;
    private double interestRate;
    private Location location;
    private LPX solutionStatus = null;

    public LPX solve(boolean exceptionOnFail, String dumpMatrix) throws GLPKException, BadModelException {
        LPX status;
        this.setFormulaVariables();
        this.solutionStatus = status = this.matrix.updateAndSolve();
        if (exceptionOnFail && status != LPX.LPX_OPT) {
            StringBuffer message = new StringBuffer();
            this.matrix.printCSV(dumpMatrix);
            message.append("Matrix written to file " + dumpMatrix);
            throw new GLPKException(message.toString());
        }
        if (dumpMatrix.length() > 0) {
            this.matrix.printCSV(dumpMatrix);
        }
        return status;
    }

    public LPX solutionStatus() {
        return this.solutionStatus;
    }

    public String solver() {
        return this.matrix.getSolverType().xmlName;
    }

    public Map<Types.ObjectiveType, Objective> objectives() {
        return this.matrix.objectives();
    }

    public List<Types.ObjectiveType> sortedObjectiveTypes() {
        ArrayList<Types.ObjectiveType> ots = new ArrayList<Types.ObjectiveType>(this.matrix.objectives().keySet());
        Collections.sort(ots);
        return Collections.unmodifiableList(ots);
    }

    public boolean needsRebuild() {
        if (this.matrix != null) {
            return this.matrix.needsRebuild();
        }
        return true;
    }

    public void setLocation(Location newLoc) {
        this.location = newLoc;
        this.matrix.flagForRebuild();
    }

    public Location location() {
        return this.location;
    }

    public void setFuelPrice(double fp) {
        this.fuelPrice = fp;
        this.cropping.updateStructure();
    }

    public double fuelPrice() {
        return this.fuelPrice;
    }

    public void setInterestRate(double ir) {
        this.interestRate = ir;
        this.workers.updateStructure();
    }

    public double interestRate() {
        return this.interestRate();
    }

    public double getValueForObjective(Types.ObjectiveType type) {
        return this.matrix.primitiveMatrix.getObjectiveValue(type);
    }

    public double getEnterpriseOutput() {
        double eo = 0.0;
        for (Types.CropType ct : this.cropping.baseCropTypes()) {
            for (Crop.CropCopy cp : this.cropping.getCrop(ct).getYearCopies()) {
                eo += cp.grossMargin() * cp.solvedArea();
            }
        }
        return eo;
    }

    public double getProfit() {
        return this.getValueForObjective(Types.ObjectiveType.PROFIT);
    }

    public double getWinterStubble() {
        return this.getValueForObjective(Types.ObjectiveType.WINTERSTUBBLE);
    }

    public void setWinterStubbleWeight(double wt) {
        if (!this.objectives().containsKey((Object)Types.ObjectiveType.WINTERSTUBBLE)) {
            throw new Error("Can't set hedge objective weight because no hedge objective defined");
        }
        this.getObjectives().get((Object)Types.ObjectiveType.WINTERSTUBBLE).setScaleFactor(wt);
    }

    public double getHedgeLength() {
        return this.getValueForObjective(Types.ObjectiveType.HEDGEROWS);
    }

    public void setHedgeWeight(double wt) {
        if (!this.objectives().containsKey((Object)Types.ObjectiveType.HEDGEROWS)) {
            throw new Error("Can't set hedge objective weight because no hedge objective defined");
        }
        this.getObjectives().get((Object)Types.ObjectiveType.HEDGEROWS).setScaleFactor(wt);
    }

    public Set<ELSOption> getELSOptionSet() {
        HashSet<ELSOption> options = new HashSet<ELSOption>();
        for (ModelComponent mc : this.components) {
            if (!(mc instanceof ELSOptionComponent)) continue;
            ELSOptionComponent mco = (ELSOptionComponent)mc;
            options.addAll(mco.getOptions());
        }
        return options;
    }

    public void disableSolverOutput() {
        this.matrix.disableSolverOutput();
    }

    public void enableSolverOutput() {
        this.matrix.enableSolverOutput();
    }

    public static Farm fromXML(Document doc) {
        Farm farm;
        FarmParser parser = new FarmParser(null);
        NodeList farmNodes = doc.getElementsByTagName("farm");
        Element farmRoot = (Element)farmNodes.item(0);
        try {
            parser.parse(farmRoot);
            farm = (Farm)parser.getObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Error("Failed to parse model");
        }
        return farm;
    }

    public static Document parseDocument(String xmlFileName) {
        File docFile = new File(xmlFileName);
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(docFile);
        }
        catch (IOException e) {
            throw new Error("Can't find the file " + e.getMessage() + " " + xmlFileName);
        }
        catch (Exception e) {
            throw new Error("Problem parsing the file." + xmlFileName);
        }
        return doc;
    }

    public static Farm fromXML(String xmlFileName) {
        return Farm.fromXML(Farm.parseDocument(xmlFileName));
    }

    public Farm(Location loc, double fuelp, double interestr, LPPeer.Solver solverType, int np, Set<ModelComponent> modelComponents) throws BadModelException {
        this.fuelPrice = fuelp;
        this.interestRate = interestr;
        this.location = loc;
        Stack<ModelComponent.MCType> compuls = new Stack<ModelComponent.MCType>();
        HashSet<Types.ObjectiveType> requiredObjectives = new HashSet<Types.ObjectiveType>();
        compuls.addAll(compulsoryComponents);
        block6: for (ModelComponent mc : modelComponents) {
            this.components.add(mc);
            mc.setParent(this);
            requiredObjectives.addAll(mc.getRequiredObjectives());
            switch (mc.type) {
                case LANDUSE: {
                    this.landUse = (LandUseComponent)mc;
                    compuls.remove((Object)ModelComponent.MCType.LANDUSE);
                    continue block6;
                }
                case CROPPING: {
                    this.cropping = (CroppingComponent)mc;
                    compuls.remove((Object)ModelComponent.MCType.CROPPING);
                    continue block6;
                }
                case WORKERS: {
                    this.workers = (WorkersComponent)mc;
                    compuls.remove((Object)ModelComponent.MCType.WORKERS);
                    continue block6;
                }
                case ROTATIONS: {
                    this.rotations = (RotationsComponent)mc;
                    compuls.remove((Object)ModelComponent.MCType.ROTATIONS);
                    continue block6;
                }
            }
            if (compuls.size() == 0) continue;
            throw new Error("Can't add non-compulsory ModelComponent " + (Object)((Object)mc.type) + " until all compulsory components have been added \n");
        }
        if (compuls.size() != 0) {
            throw new Error("The Compulsory Model components " + compuls + " \n were not specified");
        }
        this.numPeriods = np;
        HashMap<Types.ObjectiveType, Objective> objectives = new HashMap<Types.ObjectiveType, Objective>();
        for (Types.ObjectiveType otype : requiredObjectives) {
            objectives.put(otype, new Objective(otype));
        }
        this.setFormulaVariables();
        this.matrix = new Matrix(this.components, objectives, solverType);
    }

    public void setFormulaVariables() {
        for (ModelComponent mc : this.components) {
            mc.setFormulaVariables();
        }
    }

    public ModelComponent getModelComponent(ModelComponent.MCType type) {
        for (ModelComponent mc : this.components) {
            if (mc.type != type) continue;
            return mc;
        }
        throw new Error("Model Component " + (Object)((Object)type) + " not found");
    }

    public void addComponent(ModelComponent newComponent) {
        this.components.add(newComponent);
        newComponent.setParent(this);
        this.matrix.addComponent(newComponent);
    }

    public void addObjective(Objective obj) {
        this.matrix.addObjective(obj);
    }

    public Map<Types.ObjectiveType, Objective> getObjectives() {
        return this.matrix.objectives();
    }

    public Map<ModelComponent.MCType, ModelComponent> getComponents() {
        HashMap<ModelComponent.MCType, ModelComponent> cmap = new HashMap<ModelComponent.MCType, ModelComponent>();
        for (ModelComponent mc : this.components) {
            cmap.put(mc.type, mc);
        }
        return cmap;
    }

    public static Farm createTemplate(Farm base) throws BadModelException {
        Farm bb = base.copy();
        bb.cropping.clearCrops();
        bb.cropping.clearLimits();
        return bb;
    }

    public Farm copy() throws BadModelException {
        CroppingComponent croppingcpy = this.cropping.copy();
        Location loccpy = this.location.copy();
        RotationsComponent rotscpy = this.rotations.copy(croppingcpy, loccpy);
        HashSet<ModelComponent> mcCopy = new HashSet<ModelComponent>();
        for (ModelComponent mc : this.components) {
            ModelComponent mccpy = null;
            switch (mc.type) {
                case CROPPING: {
                    mccpy = croppingcpy;
                    break;
                }
                case ROTATIONS: {
                    mccpy = rotscpy;
                    break;
                }
                default: {
                    mccpy = mc.copy();
                }
            }
            mcCopy.add(mccpy);
        }
        Farm newFarm = new Farm(loccpy, this.fuelPrice, this.interestRate, this.matrix.getSolverType(), this.numPeriods, mcCopy);
        Map<Types.ObjectiveType, Objective> oldObjs = this.getObjectives();
        Map<Types.ObjectiveType, Objective> newObjs = newFarm.getObjectives();
        for (Types.ObjectiveType type : oldObjs.keySet()) {
            Objective newobj = newObjs.get((Object)type);
            newobj.setScaleFactor(oldObjs.get((Object)type).scaleFactor());
        }
        return newFarm;
    }

    static int wrapPeriod(int p, int numPeriods) {
        int yr = (int)Math.floor((double)p / (double)numPeriods);
        return p - yr * numPeriods;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.cropping + " \n " + this.rotations + " \n" + this.workers);
        return buff.toString();
    }

    public Map<Types.ObjectiveType, Double> getUnScaledObjectives() {
        HashMap<Types.ObjectiveType, Double> unscaled = new HashMap<Types.ObjectiveType, Double>();
        if (this.matrix.getSolutionStatus() == LPX.LPX_OPT) {
            for (Types.ObjectiveType ob : this.matrix.objectives().keySet()) {
                unscaled.put(ob, this.matrix.primitiveMatrix.getObjectiveValue(ob));
            }
        } else {
            throw new Error("Can't get objectives because the matrix is not at an optimal solution");
        }
        return unscaled;
    }

    public Map<Types.ObjectiveType, Double> getScaledObjectives() {
        HashMap<Types.ObjectiveType, Double> scaled = new HashMap<Types.ObjectiveType, Double>();
        if (this.matrix.getSolutionStatus() == LPX.LPX_OPT) {
            for (Objective ob : this.matrix.objectives().values()) {
                scaled.put(ob.type, this.matrix.primitiveMatrix.getObjectiveValue(ob.type) * ob.scaleFactor());
            }
        } else {
            throw new Error("Can't get objectives because the matrix is not at an optimal solution");
        }
        return scaled;
    }

    static {
        compulsoryComponents.add(ModelComponent.MCType.LANDUSE);
        compulsoryComponents.add(ModelComponent.MCType.CROPPING);
        compulsoryComponents.add(ModelComponent.MCType.WORKERS);
        compulsoryComponents.add(ModelComponent.MCType.ROTATIONS);
        maxYears = 2;
    }
}

