/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jfm.lp.ModelPrimitive;
import jfm.model.Crop;
import jfm.model.CropInput;
import jfm.model.Farm;
import jfm.model.Formula;
import jfm.model.Location;
import jfm.model.Types;
import jfm.utils.JFMMath;
import jfm.utils.MathPrint;
import jfm.xml.XMLSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Operation
extends ModelPrimitive {
    private final int numPeriods;
    private int printLeadingDigits = 2;
    private final HashMap<Integer, Double> yieldPenalties = new HashMap();
    private final HashMap<Integer, Double> costPenalties = new HashMap();
    private final HashMap<Integer, Double> minAreas = new HashMap();
    private boolean hasMinAreas = false;
    private final HashMap<Integer, Double> fuelCostCached = new HashMap();
    private final HashMap<Integer, Double> penaltyCostCached = new HashMap();
    private final Formula workrateF;
    private final HashMap<Types.WorkerType, Integer> numMachines;
    private final Types.WorkerType firstMachine;
    private Crop.CropCopy parentCrop = null;
    public final Types.OperationType type;
    public final Types.WorkabilityType workability;
    private boolean isSequential = true;
    private boolean isHandOver = false;
    private boolean isAttached = false;
    public final int gap;

    public Operation copy() {
        Operation op = new Operation(this.type, this.numPeriods, this.workability, this.workrateF, this.numMachines, this.gap, this.firstMachine);
        op.setYieldPenalties(this.yieldPenalties);
        op.setCostPenalties(this.costPenalties);
        op.setMinAreas(this.minAreas);
        if (this.hasMinAreas) {
            op.hasMinAreas = true;
        }
        if (this.isHandOver) {
            op.setHandOver();
        }
        if (!this.isSequential) {
            op.setNonSequential();
        }
        return op;
    }

    Integer numRequiredForWorkerType(Types.WorkerType wtype) {
        if (!this.numMachines.containsKey((Object)wtype)) {
            throw new Error("The worker type " + (Object)((Object)wtype) + " is not defined for operation " + (Object)((Object)this.type));
        }
        return this.numMachines.get((Object)wtype);
    }

    boolean requiresWorker(Types.WorkerType wtype) {
        return this.numMachines.containsKey((Object)wtype);
    }

    Set<Types.WorkerType> workerSet() {
        return this.numMachines.keySet();
    }

    public Operation(Types.OperationType type_, int nP, Types.WorkabilityType wkability, Formula formul, Map<Types.WorkerType, Integer> numMachines_, int gap_, Types.WorkerType firstMach) {
        this.gap = gap_;
        this.type = type_;
        this.numPeriods = nP;
        this.workability = wkability;
        this.numMachines = (HashMap)numMachines_;
        this.firstMachine = firstMach;
        this.workrateF = formul;
        if (formul != null) {
            this.workrateF.setVariable(Types.VariableType.SIZEFIRSTMACHINE, this.firstMachine.size);
        }
    }

    public void attachToCrop(Crop.CropCopy parent) {
        if (this.isAttached) {
            throw new Error("An Operation cannot be attached to more than one crop");
        }
        this.parentCrop = parent;
        this.isAttached = true;
    }

    protected void setFormulaVariables() {
        Farm parentFarm = this.parentComponent.getParent();
        Location loc = parentFarm.location();
        if (this.workrateF != null) {
            for (Types.VariableType ltype : loc.variableSet()) {
                this.workrateF.setVariable(ltype, loc.getVariable(ltype));
            }
            for (CropInput cinp : this.parentCrop.baseCrop().inputSet()) {
                this.workrateF.setVariable(cinp.associatedVariable, cinp.getVariable(cinp.associatedVariable));
            }
            this.workrateF.setVariable(Types.VariableType.PRIMARYYIELD, this.parentCrop.baseCrop().getPrimaryYield());
            this.workrateF.setVariable(Types.VariableType.SECONDARYYIELD, this.parentCrop.baseCrop().getSecondaryYield());
        }
    }

    @Override
    protected void updateStructure(Object caller) {
        Farm parentFarm = this.parentComponent.getParent();
        ArrayList<Integer> pallow = new ArrayList<Integer>(this.unfoldedAllowedSet());
        Collections.sort(pallow);
        for (Integer p : pallow) {
            this.setCoefficient(Types.ObjectiveType.PROFIT, -this.cost(p, (Crop.CropCopy)caller, parentFarm.location(), parentFarm.fuelPrice()), p);
        }
    }

    public double cost(int period, Crop.CropCopy cp, Location loc, double fuelPrice) {
        double penaltyCost = 0.0;
        double fuelCost = 0.0;
        this.setFormulaVariables();
        if (!this.yieldPenalties.containsKey(period)) {
            throw new Error("Attempt to get cost for unknown period in operation " + this.toString());
        }
        penaltyCost = cp.grossMarginLossForYieldPenalty(this.yieldPenalties.get(period));
        this.penaltyCostCached.put(period, penaltyCost += this.costPenalties.get(period).doubleValue());
        if (this.workrateF != null) {
            double fuel = 0.0;
            for (Types.WorkerType wt : this.numMachines.keySet()) {
                fuel += wt.litresPerHour();
            }
            if (this.workrate(loc) <= 0.0) {
                throw new Error("Can't set cost for operation because workrate is " + this.workrateF.calculateValue() + " in op " + (Object)((Object)this.type) + " with wkrateF " + this.workrateF.getFormula());
            }
            fuelCost += fuel * fuelPrice * this.workrateF.calculateValue();
        }
        this.fuelCostCached.put(period, fuelCost);
        return fuelCost + penaltyCost;
    }

    public double solvedPenaltyCost() {
        double[] sol = this.getSolution();
        if (sol.length != this.penaltyCostCached.size()) {
            throw new Error("Can't calculated solved penalty cost because of array length mismatch");
        }
        double total = 0.0;
        int i = 0;
        for (Double cost : this.penaltyCostCached.values()) {
            total += cost * sol[i];
            ++i;
        }
        return total;
    }

    public double solvedArea(int period) {
        return this.getDependent(period).solution();
    }

    public double solvedFuelCost() {
        double[] sol = this.getSolution();
        if (sol.length != this.fuelCostCached.size()) {
            throw new Error("Can't calculated solved fuel cost because of array length mismatch");
        }
        double total = 0.0;
        int i = 0;
        for (Double cost : this.fuelCostCached.values()) {
            total += cost * sol[i];
            ++i;
        }
        return total;
    }

    double workrate(Location loc) {
        if (!this.isAttached) {
            throw new Error("Cannot get workrate for operation because it is not attached to a crop");
        }
        if (this.workrateF != null) {
            return this.workrateF.calculateValue();
        }
        return 0.0;
    }

    private void setYieldPenalties(HashMap<Integer, Double> oldpenalties) {
        for (Integer i : oldpenalties.keySet()) {
            this.yieldPenalties.put(i, oldpenalties.get(i));
        }
    }

    private void setCostPenalties(HashMap<Integer, Double> oldpenalties) {
        for (Integer i : oldpenalties.keySet()) {
            this.costPenalties.put(i, oldpenalties.get(i));
        }
    }

    private void setMinAreas(HashMap<Integer, Double> oldminareas) {
        for (Integer i : oldminareas.keySet()) {
            this.minAreas.put(i, oldminareas.get(i));
        }
    }

    public void setMinAreas(int[] perAllow, double[] mina) throws XMLSyntaxException {
        this.hasMinAreas = true;
        if (perAllow.length != mina.length) {
            throw new XMLSyntaxException("Periods length mismatch " + perAllow.length + " vs " + mina.length);
        }
        for (int i = 0; i < perAllow.length; ++i) {
            this.minAreas.put(perAllow[i], mina[i]);
        }
        this.requireMatrixRebuild();
    }

    public void setYieldPenalties(int[] perAllow, double[] penalt) throws XMLSyntaxException {
        if (perAllow.length != penalt.length) {
            throw new XMLSyntaxException("Periods length mismatch " + perAllow.length + " vs " + penalt.length);
        }
        for (int i = 0; i < perAllow.length; ++i) {
            this.yieldPenalties.put(perAllow[i], penalt[i]);
        }
        this.requireMatrixRebuild();
    }

    public void setCostPenalties(int[] perAllow, double[] costp) throws XMLSyntaxException {
        if (perAllow.length != costp.length) {
            throw new XMLSyntaxException("Periods length mismatch for cost penalties");
        }
        for (int i = 0; i < perAllow.length; ++i) {
            this.costPenalties.put(perAllow[i], costp[i]);
        }
        this.requireMatrixRebuild();
    }

    @Override
    public String name() {
        return "Operation";
    }

    public boolean hasMinAreas() {
        return this.hasMinAreas;
    }

    public double minArea(int period) {
        if (this.hasMinAreas) {
            return this.minAreas.get(period);
        }
        throw new Error("Attempt to get min area but non defined for this operation");
    }

    public void setNonSequential() {
        this.isSequential = false;
        this.requireMatrixRebuild();
    }

    public boolean isSequential() {
        return this.isSequential;
    }

    public void setHandOver() {
        this.isHandOver = true;
        this.requireMatrixRebuild();
    }

    public boolean isHandOver() {
        return this.isHandOver;
    }

    public Set<Integer> unfoldedAllowedSet() {
        return this.yieldPenalties.keySet();
    }

    public Set<Integer> foldedAllowedSet() {
        HashSet<Integer> allow = new HashSet<Integer>();
        for (Integer p : this.yieldPenalties.keySet()) {
            allow.add(Farm.wrapPeriod(p, this.numPeriods));
        }
        return allow;
    }

    public void setLeadingDigits(int ld) {
        this.printLeadingDigits = ld;
    }

    public String printWorkRateDetails(Location loc) {
        StringBuffer outstring = new StringBuffer();
        outstring.append(this.workrate(loc));
        outstring.append(',');
        outstring.append((Object)this.workability);
        return outstring.toString();
    }

    public String printSolution(char sep) {
        StringBuffer outstring = new StringBuffer();
        outstring.append(this.type.shortName);
        outstring.append(sep);
        double[] sol = this.getSolution();
        double[] fullsol = new double[this.numPeriods];
        JFMMath.doubleZero(fullsol);
        int i = 0;
        ArrayList<Integer> pallow = new ArrayList<Integer>(this.unfoldedAllowedSet());
        Collections.sort(pallow);
        for (Integer p : pallow) {
            fullsol[Farm.wrapPeriod((int)p.intValue(), (int)this.numPeriods)] = sol[i];
            ++i;
        }
        outstring.append(MathPrint.printVector(fullsol, this.printLeadingDigits, sep));
        return outstring.toString();
    }

    public String toString() {
        StringBuffer outstring = new StringBuffer();
        outstring.append("Operation: " + this.type.shortName);
        outstring.append(" isHandOver: " + this.isHandOver);
        outstring.append(" NumPeriods: ");
        outstring.append(this.numPeriods);
        outstring.append(" \n");
        outstring.append("Areas by Period:      " + MathPrint.printVector(this.getSolution(), 2, ' '));
        outstring.append("Penalties:            " + MathPrint.printVector(this.getCoefficients(Types.ObjectiveType.PROFIT), 2, ' '));
        for (Types.ObjectiveType ot : this.objectives()) {
            if (ot == Types.ObjectiveType.PROFIT) continue;
            outstring.append((Object)((Object)ot) + ":      " + MathPrint.printVector(this.getCoefficients(ot), 2, ' '));
        }
        outstring.append("Hours Required: \n");
        for (Types.WorkerType wt : Types.WorkerType.values()) {
        }
        return outstring.toString();
    }
}

