/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jfm.model.Types;
import jfm.utils.JFMMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotationMatrix {
    public final int size;
    public final double[][] rmatrix;
    public final double[] rvector;
    private final List<Types.CropType> cropTypes = new ArrayList<Types.CropType>();

    public List<Types.CropType> cropTypes() {
        return Collections.unmodifiableList(this.cropTypes);
    }

    public Types.CropType pickNewCrop(Types.CropType prev, double random) {
        int fi = -1;
        if (prev == null || !this.cropTypes.contains((Object)prev)) {
            JFMMath.doubleZero(this.rvector);
            for (int i = 0; i < this.rmatrix.length; ++i) {
                for (int j = 0; j < this.rmatrix.length; ++j) {
                    int n = i;
                    this.rvector[n] = this.rvector[n] + this.rmatrix[i][j];
                }
            }
            fi = JFMMath.chooseWeightedRandom(this.rvector, random);
        } else {
            fi = this.cropTypes.indexOf((Object)prev);
        }
        Types.CropType next = null;
        double[] pickP = new double[this.rmatrix[fi].length];
        double totFi = JFMMath.sum(this.rmatrix[fi]);
        if (totFi == 0.0) {
            throw new Error("Rotation matrix should not contain any zero columns or rows \n" + this.toString() + "\n");
        }
        pickP[0] = this.rmatrix[fi][0] / totFi;
        for (int i = 1; i < pickP.length; ++i) {
            pickP[i] = pickP[i - 1] + this.rmatrix[fi][i] / totFi;
            if (!(pickP[i] >= random) || next != null) continue;
            next = this.cropTypes.get(i);
        }
        if (!JFMMath.isZero(pickP[pickP.length - 1] - 1.0)) {
            throw new Error("rmatrix unnormalizable?!");
        }
        return next;
    }

    public RotationMatrix(Set<Types.CropType> crops) {
        this.size = crops.size();
        this.cropTypes.addAll(crops);
        this.rmatrix = new double[this.size][this.size];
        this.rvector = new double[this.size];
        JFMMath.doubleZero(this.rvector);
        JFMMath.doubleZero(this.rmatrix);
    }

    public void addElement(Types.CropType from, Types.CropType to, Double area) {
        this.checkIndices(from, to);
        int f = this.cropTypes.indexOf((Object)from);
        int t = this.cropTypes.indexOf((Object)to);
        double[] dArray = this.rmatrix[f];
        int n = t;
        dArray[n] = dArray[n] + area;
    }

    private void checkIndices(Types.CropType from, Types.CropType to) {
        if (!this.cropTypes.contains((Object)from)) {
            throw new Error("From crop type not recognised by RotationMatrix");
        }
        if (!this.cropTypes.contains((Object)to)) {
            throw new Error("To crop type not recognised by RotationMatrix");
        }
    }

    public double getArea(Types.CropType from, Types.CropType to) {
        this.checkIndices(from, to);
        int f = this.cropTypes.indexOf((Object)from);
        int t = this.cropTypes.indexOf((Object)to);
        return this.rmatrix[f][t];
    }

    public boolean isValid() {
        double[] fromAreas = new double[this.size];
        JFMMath.doubleZero(fromAreas);
        double[] toAreas = new double[this.size];
        JFMMath.doubleZero(toAreas);
        for (int f = 0; f < this.size; ++f) {
            for (int t = 0; t < this.size; ++t) {
                int n = f;
                fromAreas[n] = fromAreas[n] + this.rmatrix[f][t];
                int n2 = t;
                toAreas[n2] = toAreas[n2] + this.rmatrix[f][t];
            }
        }
        for (int c = 0; c < this.size; ++c) {
            if (!JFMMath.isZero(toAreas[c] - fromAreas[c])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        DecimalFormat d3 = new DecimalFormat("#000");
        StringBuffer buff = new StringBuffer();
        buff.append("   ");
        for (int f = 0; f < this.rmatrix.length; ++f) {
            buff.append(this.cropTypes.get((int)f).shortName + " ");
        }
        buff.append("\n");
        for (int t = 0; t < this.rmatrix[0].length; ++t) {
            buff.append(this.cropTypes.get((int)t).shortName + " ");
            for (int f = 0; f < this.rmatrix.length; ++f) {
                buff.append(d3.format(this.rmatrix[f][t]) + " ");
            }
            buff.append("\n");
        }
        return buff.toString();
    }
}

