% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr}
\alias{qr}
\title{The QR factorization of a matrix}
\arguments{
\item{X}{a \eqn{n\times p} matrix.}

\item{type}{either "givens" or "householder".}

\item{nb}{integer. Defines the number of block in the block recursive QR decomposition. See Golud and van Loan (2013).}

\item{complete}{logical expression of length 1. Indicates whether an arbitrary orthogonal completion of the \eqn{Q} matrix is to be made, or whether the \eqn{R} matrix is to be completed by binding zero-value rows beneath the square upper triangle.}
}
\value{
A named list containing \describe{
\item{Q}{the Q matrix.}
\item{R}{the R matrix.}
}
}
\description{
qr provides the QR factorization of the matrix \eqn{X\in\mathbb{R}^{n\times p}} with \eqn{n>p}. The QR factorization of the matrix \eqn{X} returns the matrices \eqn{Q\in\mathbb{R}^{n\times n}} and \eqn{R\in\mathbb{R}^{n\times p}} such that \eqn{X=QR}. See Golub and Van Loan (2013) for further details on the method.
}
\examples{
## generate sample data
set.seed(1234)
n <- 10
p <- 6
X <- matrix(rnorm(n * p, 1), n, p)

## QR factorization via Givens rotation
output <- qr(X, type = "givens", complete = TRUE)
Q      <- output$Q
R      <- output$R

## check
round(Q \%*\% R - X, 5)
max(abs(Q \%*\% R - X))

## QR factorization via Householder rotation
output <- qr(X, type = "householder", complete = TRUE)
Q      <- output$Q
R      <- output$R

## check
round(Q \%*\% R - X, 5)
max(abs(Q \%*\% R - X))

}
\references{
\insertRef{golub_van_loan.2013}{fastQR}

\insertRef{bjorck.2015}{fastQR}

\insertRef{bjorck.2024}{fastQR}

\insertRef{bernardi_etal.2024}{fastQR}
}
