% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Stereogram}
\alias{Stereogram}
\title{Stereogram fusion}
\format{A data frame with 78 observations on the following 2 variables.
\itemize{ \item{time}{time until subject was able to fuse a random
dot stereogram} \item{group}{treatment group: \code{NV}(no visual
instructions) \code{VV} (visual instructions)} }}
\source{
These data are available at DASL, the data and story library
(\url{http://lib.stat.cmu.edu/DASL/}).
}
\description{
Results of an experiment on the effect of prior information on the time to
fuse random dot steregrams. One group (NV) was given either no information
or just verbal information about the shape of the embedded object. A second
group (group VV) received both verbal information and visual information
(e.g., a drawing of the object).
}
\examples{

data(Stereogram)
favstats(time ~ group, data = Stereogram)
gf_violin(time ~ group, data = Stereogram, alpha = 0.2, fill = "skyblue") \%>\%
gf_jitter(time ~ group, data = Stereogram, height = 0, width = 0.25)

}
\references{
Frisby, J. P.  and Clatworthy, J. L., "Learning to see complex
random-dot stereograms," \emph{Perception}, 4, (1975), pp. 173-178.

Cleveland, W. S. \emph{Visualizing Data}. 1993.
}
\keyword{datasets}
