% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd.arima}
\alias{fastcpd.arima}
\alias{fastcpd_arima}
\title{Find change points efficiently in ARIMA(p, d, q) models}
\usage{
fastcpd.arima(data, order = 0, ...)

fastcpd_arima(data, order = 0, ...)
}
\arguments{
\item{data}{A numeric vector, a matrix, a data frame or a time series object.}

\item{order}{A vector of length three specifying the order of the ARIMA
model.}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}. One special argument can be passed here is
\code{include.mean}, which is a logical value indicating whether the
mean should be included in the model. The default value is \code{TRUE}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{fastcpd_arima} and \code{fastcpd.arima} are
wrapper functions of \code{\link{fastcpd}} to find change points in
ARIMA(p, d, q) models. The function is similar to \code{\link{fastcpd}}
except that the data is by default a one-column matrix or univariate vector
and thus a formula is not required here.
}
\examples{
\donttest{
if (!requireNamespace("ggplot2", quietly = TRUE)) utils::install.packages(
  "ggplot2", repos = "https://cloud.r-project.org", quiet = TRUE
)

set.seed(1)
n <- 271
w <- rnorm(n + 1, 0, 3)
dx <- rep(0, n + 1)
x <- rep(0, n + 1)
for (i in 1:180) {
  dx[i + 1] <- 0.8 * dx[i] + w[i + 1] - 0.5 * w[i]
  x[i + 1] <- x[i] + dx[i + 1]
}
for (i in 181:n) {
  dx[i + 1] <- -0.6 * dx[i] + w[i + 1] + 0.3 * w[i]
  x[i + 1] <- x[i] + dx[i + 1]
}
result <- fastcpd.arima(
  diff(x[1 + seq_len(n)]),
  c(1, 0, 1),
  segment_count = 3,
  include.mean = FALSE
)
summary(result)
plot(result)
}
}
