% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd_ts}
\alias{fastcpd_ts}
\alias{fastcpd.ts}
\title{Find change points efficiently in time series data}
\usage{
fastcpd_ts(data, family = NULL, order = c(0, 0, 0), ...)

fastcpd.ts(data, family = NULL, order = c(0, 0, 0), ...)
}
\arguments{
\item{data}{A numeric vector, a matrix, a data frame or a time series object.}

\item{family}{A character string specifying the family of the time series.
The value should be one of \code{"ar"}, \code{"var"}, \code{"arima"} or
\code{"garch"}.}

\item{order}{A positive integer or a vector of length less than four
specifying the order of the time series. Possible combinations with
\code{family} are:
\itemize{
\item \code{"ar"}, NUMERIC(1): AR(\eqn{p}) model using linear regression.
\item \code{"var"}, NUMERIC(1): VAR(\eqn{p}) model using linear regression.
\item \code{"ma"}, NUMERIC(1): MA(\eqn{q}) model using \code{\link[forecast:Arima]{forecast::Arima()}}.
\item \code{"ma"}, NUMERIC(3): ARIMA(0, 0, \eqn{q}) model using
\code{\link[forecast:Arima]{forecast::Arima()}}, where \eqn{q} is the third element of the vector.
\item \code{"arima"}, NUMERIC(3): ARIMA(\eqn{p}, \eqn{d}, \eqn{q}) model
using \code{\link[forecast:Arima]{forecast::Arima()}}.
\item \code{"garch"}, NUMERIC(2): GARCH(\eqn{p}, \eqn{q}) model using
\code{\link[tseries:garch]{tseries::garch()}}.
}}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}. One special argument can be passed here is
\code{include.mean}, which is a logical value indicating whether the
mean should be included in the model. The default value is \code{TRUE}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_ts]{fastcpd_ts()}} and \code{\link[=fastcpd.ts]{fastcpd.ts()}} are wrapper functions for
\code{\link[=fastcpd]{fastcpd()}} to find change points in time series data. The function is
similar to \code{\link[=fastcpd]{fastcpd()}} except that the data is a time series and the
family is one of \code{"ar"}, \code{"var"}, \code{"arma"}, \code{"arima"} or
\code{"garch"}.
}
\examples{
\donttest{
if (!requireNamespace("ggplot2", quietly = TRUE)) utils::install.packages(
  "ggplot2", repos = "https://cloud.r-project.org", quiet = TRUE
)

set.seed(1)
n <- 250
x <- rep(0, n + 1)
for (i in 1:180) {
  x[i + 1] <- 0.8 * x[i] + rnorm(1, 0, 2)
}
for (i in 181:n) {
  x[i + 1] <- 0.1 * x[i] + rnorm(1, 0, 2)
}
result <- fastcpd.ts(
  x[1 + seq_len(n)],
  "arima",
  c(1, 0, 0),
  include.mean = FALSE,
  trim = 0,
  beta = (1 + 1 + 1) * log(n) / 2 * 3
)
summary(result)
plot(result)
}
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
