% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_data.R
\docType{data}
\name{well_log}
\alias{well_log}
\title{Well-log Dataset from Numerical Bayesian Methods Applied to
Signal Processing}
\format{
A Time-Series of length 3989.
}
\source{
<https://github.com/alan-turing-institute/TCPD>
}
\usage{
well_log
}
\description{
This is the well-known well-log dataset used in many changepoint
papers obtained from Alan Turing Institute GitHub repository and licensed
under the MIT license. Outliers with value less or equal to 1e5 are removed.
}
\examples{
if (!requireNamespace("ggplot2", quietly = TRUE)) utils::install.packages(
  "ggplot2", repos = "https://cloud.r-project.org", quiet = TRUE
)

result <- fastcpd.mean(well_log, trim = 0.003)
summary(result)
plot(result)
if (!requireNamespace("ggplot2", quietly = TRUE)) utils::install.packages(
  "ggplot2", repos = "https://cloud.r-project.org", quiet = TRUE
)

result <- fastcpd.mean(
  well_log, beta = (1 + 2) * log(length(well_log)) / 2 * 6, trim = 0.002
)
summary(result)
plot(result)
\donttest{
for (package in c("ggplot2", "matrixStats")) {
  if (!requireNamespace(package, quietly = TRUE)) utils::install.packages(
    package, repos = "https://cloud.r-project.org", quiet = TRUE
  )
}

sigma2 <- variance.median(well_log)
median_loss <- function(data) {
  sum(abs(data - matrixStats::colMedians(data))) / sqrt(sigma2) / 2
}
result <- fastcpd(
  formula = ~ x - 1,
  data = cbind.data.frame(x = well_log),
  cost = median_loss,
  trim = 0.002
)
summary(result)

segment_starts <- c(1, result@cp_set)
segment_ends <- c(result@cp_set - 1, length(well_log))
residual <- NULL
for (segment_index in seq_along(segment_starts)) {
  segment <- well_log[segment_starts[segment_index]:segment_ends[segment_index]]
  residual <- c(residual, segment - median(segment))
}

result@residuals <- residual
result@family <- "mean"
result@data <- data.frame(x = c(well_log))
plot(result)
}
}
\keyword{datasets}
