% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R, R/init.R
\name{fit_glmpca_pois}
\alias{fit_glmpca_pois}
\alias{fit_glmpca_pois_control_default}
\alias{init_glmpca_pois}
\title{Fit Poisson GLM-PCA Model to Count Data}
\usage{
fit_glmpca_pois(
  Y,
  K,
  fit0 = init_glmpca_pois(Y, K),
  verbose = TRUE,
  control = list()
)

fit_glmpca_pois_control_default()

init_glmpca_pois(
  Y,
  K,
  U,
  V,
  X = numeric(0),
  Z = numeric(0),
  B = numeric(0),
  W = numeric(0),
  fixed_b_cols = numeric(0),
  fixed_w_cols = numeric(0),
  col_size_factor = TRUE,
  row_intercept = TRUE
)
}
\arguments{
\item{Y}{The n x m matrix of counts; all entries of \code{Y} should
be non-negative. It can be a sparse matrix (class
\code{"dsparseMatrix"}) or dense matrix (class \code{"matrix"}).}

\item{K}{Integer 1 or greater specifying the rank of the matrix
factorization. This should only be provided if the initial fit
(\code{fit0}) is not.}

\item{fit0}{Initial model fit. It should be an object of class
\dQuote{glmpca_fit_pois}, such as an output from
\code{init_glmpca_pois} or a previous call to
\code{fit_glmpca_pois}.}

\item{verbose}{If \code{verbose = TRUE}, information about the
algorithm's progress is printed after each update.}

\item{control}{List of control parameters to modify behavior of
the optimization algorithm; see \dQuote{Details}.}

\item{U}{An optional argument giving the initial estimate of the
loadings matrix. It should be an n x K matrix, where n is the
number of rows in the counts matrix \code{Y}, and K > 0 is the rank
of the matrix factorization. When \code{U} and \code{V} are not
provided, input argument \code{K} should be specified instead.}

\item{V}{An optional argument giving is the initial estimate of the
factors matrix. It should be a m x K matrix, where m is the number
of columns in the counts matrix \code{Y}, and K > 0 is the rank of
the matrix factorization. When \code{U} and \code{V} are not
provided, input argument \code{K} should be specified instead.}

\item{X}{Optional argument giving row covariates of the count
matrix \code{Y}. It should be an n x nx matrix, where nx is
the number of row covariates.}

\item{Z}{Optional argument giving column covariates of the count
matrix \code{Y}. It should be an m x nz matrix, where nz is the
number of column covariates.}

\item{B}{Optional argument giving the initial estimates for the
coefficients of the row covariates. It should be an m x nx matrix,
where nx is the number of row covariates.
This argument is ignored if X is not provided.}

\item{W}{Optional argument giving the initial estimates for the
coefficients of the column covariates.  It should be an n x nz matrix,
where nz is the number of column covariates.
This argument is ignored if Z is not provided.}

\item{fixed_b_cols}{Optional numeric vector specifying which
columns of \code{B} (if any) should be fixed during
optimization. This argument is ignored if X is not provided.}

\item{fixed_w_cols}{Optional numeric vector specifying which
columns of \code{W} (if any) should be fixed during
optimization. This argument is ignored if Z is not provided.}

\item{col_size_factor}{If \code{col_size_factor = TRUE}, add a
fixed factor accounting for average differences in Poisson rates
across columns of \code{Y}. Setting \code{col_size_factor = TRUE}
and \code{row_intercept = TRUE} is intended to replicate the
default behavior of \code{glmpca}.}

\item{row_intercept}{If \code{row_intercept = TRUE}, add a factor
accounting for average differences in Poisson rates across rows of
\code{Y}. Setting \code{col_size_factor = TRUE} and
\code{row_intercept = TRUE} is intended to replicate the default
behavior of \code{glmpca}.}
}
\value{
An object capturing the state of the model fit. It contains
  estimates of \eqn{U}, \eqn{V} and \eqn{D} (stored as matrices
  \code{U}, \code{V} and a vector of diagonal entries \code{d},
  analogous to the \code{\link{svd}} return value); the other
  parameters (\eqn{X}, \eqn{B}, \eqn{Z}, \eqn{W}); the log-likelihood
  achieved (\code{loglik}); information about which columns of
  \eqn{B} and \eqn{W} are fixed (\code{fixed_b_cols},
  \code{fixed_w_cols}); and a data frame \code{progress} storing
  information about the algorithm's progress after each update.
}
\description{
Fit a Poisson GLM-PCA model by maximum-likelihood.
}
\details{
In generalized principal component analysis (GLM-PCA)
based on a Poisson likelihood, the counts \eqn{y_{ij}} stored in an
\eqn{n \times m}{n x m} matrix \eqn{Y} are modeled as \deqn{y_{ij}
\sim Pois(\lambda_{ij}),} in which the logarithm of each rate
parameter \eqn{\lambda_{ij}} is defined as a linear combination of
rank-K matrices to be estimated from the data: \deqn{\log
\lambda_{ij} = (UDV')_{ij},} where \eqn{U} and \eqn{V} are
orthogonal matrices of dimension \eqn{n \times K}{n x K} and \eqn{m
\times K}{m x K}, respectively, and \eqn{D} is a diagonal \eqn{K
\times K}{K x K} matrix in which the entries along its diagonal are
positive and decreasing. \eqn{K} is a tuning parameter specifying
the rank of the matrix factorization. This is the same as the
low-rank matrix decomposition underlying PCA (that is, the singular
value decomposition), but because we are not using a linear
(Gaussian) model, this is called \dQuote{generalized PCA} or
\dQuote{GLM PCA}.

To allow for additional components that may be fixed,
\code{fit_glmpca_pois} can also fit the more general model
\deqn{\log \lambda_{ij} = (UDV' + XB' + WZ')_{ij},} in which
\eqn{X}, \eqn{Z} are fixed matrices of dimension \eqn{n \times
n_x}{n x n_x} and \eqn{m \times n_z}{m x n_z}, respectively, and
\eqn{B}, \eqn{W} are matrices of dimension \eqn{m \times n_x}{m x
n_x} and \eqn{n \times n_z}{n x n_z} to be estimated from the data.

\code{fit_glmpca_pois} computes maximum-likelihood estimates (MLEs)
of \eqn{U}, \eqn{V}, \eqn{D}, \eqn{B} and \eqn{W} satistifying the
orthogonality constraints for \eqn{U} and \eqn{V} and the
additional constraints on \eqn{D} that the entries are positive and
decreasing. This is accomplished by iteratively fitting a series of
Poisson GLMs, where each of these individual Poissons GLMs is fitted
using a fast \dQuote{cyclic co-ordinate descent} (CCD) algorithm.

The \code{control} argument is a list in which any of the following
named components will override the default optimization algorithm
settings (as they are defined by
\code{fit_glmpca_pois_control_default}). Additional control
arguments not listed here can be used to control the behaviour of
\code{\link[daarem]{fpiter}} or \code{\link[daarem]{daarem}}; see
the help accompanying these functions for details.

\describe{

\item{\code{use_daarem}}{If \code{use_daarem = TRUE}, the updates
  are accelerated using DAAREM; see \code{\link[daarem]{daarem}} for
  details.}

\item{\code{tol}}{This is the value of the \dQuote{tol} control
  argument for \code{\link[daarem]{fpiter}} or
  \code{\link[daarem]{daarem}} that determines when to stop the
  optimization. In brief, the optimization stops when the change in
  the estimates or in the log-likelihood between two successive
  updates is less than \dQuote{tol}.}

\item{\code{maxiter}}{This is the value of the \dQuote{maxiter}
  control argument for \code{\link[daarem]{fpiter}} or
  \code{\link[daarem]{daarem}}. In brief, it sets the upper limit on
  the number of CCD updates.}

\item{\code{convtype}}{This is the value of the \dQuote{convtype}
  control argument for \code{\link[daarem]{daarem}}. It determines
  whether the stopping criterion is based on the change in the
  estimates or the change in the log-likelihood between two
  successive updates.}

\item{\code{mon.tol}}{This is the value of the \dQuote{mon.tol}
  control argument for \code{\link[daarem]{daarem}}. This setting
  determines to what extent the monotonicity condition can be
  violated.}
  
\item{\code{training_frac}}{Fraction of the columns of input data \code{Y}
  to fit initial model on. If set to \code{1} (default), the model is fit
  by optimizing the parameters on the entire dataset. If set between \code{0}
  and \code{1}, the model is optimized by first fitting a model on a randomly
  selected fraction of the columns of \code{Y}, and then projecting the 
  remaining columns of \code{Y} onto the solution. Setting this to a smaller
  value will increase speed but decrease accuracy.
}

\item{\code{num_projection_ccd_iter}}{Number of co-ordinate descent updates
  be made to elements of \code{V} if and when a subset of \code{Y} is 
  projected onto \code{U}. Only used if \code{training_frac} is less than 
  \code{1}.
}

\item{\code{num_ccd_iter}}{Number of co-ordinate descent updates to
  be made to parameters at each iteration of the algorithm.}

\item{\code{line_search}}{If \code{line_search = TRUE}, a
  backtracking line search is performed at each iteration of CCD to
  guarantee improvement in the objective (the log-likelihood).}

\item{\code{ls_alpha}}{alpha parameter for backtracking line search.
  (Should be a number between 0 and 0.5, typically a number near
  zero.)}

\item{\code{ls_beta}}{beta parameter for backtracking line search
  controlling the rate at which the step size is decreased.
  (Should be a number between 0 and 0.5.)}

\item{\code{calc_deriv}}{If \code{calc_deriv = TRUE}, the maximum
  gradient of \eqn{U} and \eqn{V} is calculated and stored after each
  update. This may be useful for assessing convergence of the
  optimization, though increases overhead.}

\item{\code{calc_max_diff}}{If \code{calc_max_diff = TRUE}, the
  largest change in \eqn{U} and \eqn{V} after each update is
  calculated and stored. This may be useful for monitoring progress
  of the optimization algorithm.}

\item{\code{orthonormalize}}{If \code{orthonormalize = TRUE}, the
  matrices \eqn{U} and \eqn{V} are made to be orthogonal after each
  update step. This improves the speed of convergence without the
  DAAREM acceleration; however, should not be used when
  \code{use_daarem = TRUE}.}}

You may use function \code{\link{set_fastglmpca_threads}} to adjust
the number of threads used in performing the updates.
}
\examples{
set.seed(1)
n <- 200
p <- 100
K <- 3
dat  <- generate_glmpca_data_pois(n,p,K)
fit0 <- init_glmpca_pois(dat$Y,K)
fit  <- fit_glmpca_pois(dat$Y,fit0 = fit0)

}
\references{
Townes, F. W., Hicks, S. C., Aryee, M. J. and Irizarry,
  R. A. (2019). Feature selection and dimension reduction for
  single-cell RNA-Seq based on a multinomial model. \emph{Genome Biology}
  \bold{20}, 295. \doi{10.1186/s13059-019-1861-6}

  Collins, M., Dasgupta, S. and Schapire, R. E. (2002). A
  generalization of principal components analysis to the exponential
  family. In \emph{Advances in Neural Information Processing Systems} 14.
}
\seealso{
\code{\link{fit_glmpca_pois}}
}
