% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fastpam}
\alias{fastpam}
\title{FastPAM}
\usage{
fastpam(
  rdist,
  n,
  k,
  maxiter = 0L,
  initializer = "LAB",
  fasttol = 1,
  seed = 123456789L
)
}
\arguments{
\item{rdist}{The distance matrix (lower triangular matrix, column wise storage)}

\item{n}{The number of observations}

\item{k}{The number of clusters to produce.}

\item{maxiter}{The maximum number of iterations (default: 0)}

\item{initializer}{Initializer: either "BUILD" (used in classic PAM) or "LAB" (linear approximative BUILD)
Because of the speed benefits, "LAB" is suggested, and one can try multiple times if the runtime permits.}

\item{fasttol}{Tolerance for fast swapping behavior (may perform worse swaps). 
Default: 1.0, which means to perform any additional swap that gives an improvement.
When set to 0, it will only execute an additional swap if it appears to be independent
(i.e., the improvements resulting from the swap have not decreased when the first swap was executed).}

\item{seed}{Seed for random number generator. Default: 123456789}
}
\value{
KMedoids S4 class
}
\description{
FastPAM: An improved version of PAM, that is usually O(k) times faster.
Because of the speed benefits, we also suggest to use a linear-time
initialization, such as the k-means++ initialization or the proposed
LAB (linear approximative BUILD, the third component of FastPAM)
initialization, and try multiple times if the runtime permits.
(Schubert and Rousseeuw, 2019)
}
\references{
Erich Schubert, Peter J. Rousseeuw 
"Faster k-Medoids Clustering: Improving the PAM, CLARA, and CLARANS Algorithms"
2019 https://arxiv.org/abs/1810.05691
}
