% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{fastverse_deps}
\alias{fastverse_deps}
\title{List all fastverse dependencies}
\usage{
fastverse_deps(
  pkg = fastverse_packages(),
  recursive = FALSE,
  repos = getOption("repos"),
  include.self = FALSE,
  check.deps = TRUE
)
}
\arguments{
\item{pkg}{character vector of packages to check dependencies and versions of. The default is all \emph{fastverse} packages.}

\item{recursive}{logical. \code{TRUE} recursively determines all packages required to operate these packages.
\code{FALSE} will only list the packages and their direct dependencies.}

\item{repos}{character vector. Base URL(s) of the repositories to use, e.g., the URL of a CRAN mirror such as \code{"https://cloud.r-project.org"}. 
The macro \code{.fastverse_repos} contains the URL of the \href{https://fastverse.r-universe.dev}{fastverse r-universe server} to check/install the development version of packages.}

\item{include.self}{logical. \code{TRUE} also includes the \emph{fastverse} package and checks against the repository version.}

\item{check.deps}{logical. \code{FALSE} will not determine dependencies but only display the update status of packages in \code{pkg}.}
}
\value{
A data frame giving the package names, the repository and local version, and a logical variable stating whether the local version is behind the repository version.
}
\description{
Lists all \emph{fastverse} dependencies and the local and repository (e.g. CRAN) versions of packages and dependencies.
}
\seealso{
\code{\link{fastverse_sitrep}}, \code{\link{fastverse}}
}
