% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts.R
\name{contr_code_helmert}
\alias{contr_code_helmert}
\title{Helmert code a factor}
\usage{
contr_code_helmert(fct, levels = NULL, colnames = NULL)
}
\arguments{
\item{fct}{the factor to contrast code (or a vector)}

\item{levels}{the levels of the factor in order}

\item{colnames}{optional list of column names for the added contrasts}
}
\value{
the factor with contrasts set
}
\description{
Helmert coding sets the grand mean as the intercept. 
Each contrast compares one level with the mean of previous levels.
}
\examples{
df <- sim_design(between = list(pet = c("cat", "dog")), 
                 mu = c(10, 20), plot = FALSE)
df$pet <- contr_code_helmert(df$pet)
lm(y ~ pet, df) \%>\% broom::tidy()

df <- sim_design(between = list(pet = c("cat", "dog", "ferret")), 
                 mu = c(2, 4, 9), empirical = TRUE, plot = FALSE)
                 
df$pet <- contr_code_helmert(df$pet)
lm(y ~ pet, df) \%>\% broom::tidy()

# reorder the levels to change the comparisons
df$pet <- contr_code_helmert(df$pet, levels = c("dog", "cat", "ferret"))
lm(y ~ pet, df) \%>\% broom::tidy()

df$pet <- contr_code_helmert(df$pet, levels = c("ferret", "dog", "cat"))
lm(y ~ pet, df) \%>\% broom::tidy()
}
