% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsing_and_conversion.R
\name{expanded_to_glpk}
\alias{expanded_to_glpk}
\title{Parse a long format metabolic model to a glpk model}
\usage{
expanded_to_glpk(reactions_expanded)
}
\arguments{
\item{reactions_expanded}{A list of data frames as output by \code{reactiontbl_to_expanded}}
}
\value{
A list suitable for input to Rglpk
}
\description{
This parses the long format produced by \code{reactiontbl_to_expanded} to a glpk model.
}
\details{
To install the Rglpk package in linux, run \code{sudo apt-get install libglpk-dev} in a terminal, and then run \code{install.packages('Rglpk')} in R.

The \code{reaction_table} must have columns:
\itemize{
 \item \code{abbreviation},
 \item \code{equation},
 \item \code{uppbnd},
 \item \code{lowbnd}, and
 \item \code{obj_coef}.
}
}
\examples{
data(ecoli_core)
library(dplyr)

glpk_model <- ecoli_core \%>\%
  reactiontbl_to_expanded \%>\%
  expanded_to_glpk
  
if(requireNamespace('Rglpk', quietly=TRUE)){

  glpk_result <- purrr::lift_dl(Rglpk::Rglpk_solve_LP)(glpk_model)
  
  ecoli_core_with_flux <- ecoli_core \%>\%
    mutate(flux = glpk_result[['solution']])
}
}
\seealso{
Other parsing_and_conversion: \code{\link{expanded_to_ROI}},
  \code{\link{expanded_to_gurobi}},
  \code{\link{reactiontbl_to_expanded}},
  \code{\link{reactiontbl_to_gurobi}}
}

