% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience_wrappers.R
\name{find_fluxes_df}
\alias{find_fluxes_df}
\title{Given a metabolic model as a data frame, return a new data frame with fluxes}
\usage{
find_fluxes_df(reaction_table, do_minimization = FALSE)
}
\arguments{
\item{reaction_table}{a data frame representing the metabolic model}

\item{do_minimization}{toggle to uniformly minimize all non-objective fluxes after finding the objective}
}
\value{
The input data frame with a new numeric column, "\code{flux}".
}
\description{
Given a metabolic model as a data frame, return a new data frame with fluxes
}
\details{
This function uses ROI, so to solve models, you will need a solver plugin for ROI. Probably the easiest one to install is ROI.plugin.glpk.
To install this in Linux, run \code{sudo apt-get install libglpk-dev} in a terminal, and then run \code{install.packages('ROI.plugin.glpk')} in R.
}
\examples{
\dontrun{
data(ecoli_core)
ecoli_core_with_flux <- find_fluxes_df(ecoli_core)
}
}
\seealso{
find_fluxes_vector
}
