% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliasLocus.R
\name{FamiliasLocus}
\alias{FamiliasLocus}
\title{FamiliasLocus: a function for reading Familias locus data.}
\usage{
FamiliasLocus(
  frequencies,
  allelenames,
  name,
  MutationModel = "Stepwise",
  MutationRate = 0,
  MutationRange = 0.5,
  MutationRate2 = 0,
  MutationMatrix,
  Stabilization = "None",
  MaxStabilizedMutrate = 1,
  femaleMutationModel,
  femaleMutationRate,
  femaleMutationRange,
  femaleMutationRate2,
  femaleMutationMatrix,
  maleMutationModel,
  maleMutationRate,
  maleMutationRange,
  maleMutationRate2,
  maleMutationMatrix
)
}
\arguments{
\item{frequencies}{allele frequencies}

\item{allelenames}{names}

\item{name}{system name}

\item{MutationModel}{model}

\item{MutationRate}{rates}

\item{MutationRange}{range}

\item{MutationRate2}{rate two, applied for extended stepwise}

\item{MutationMatrix}{matrix}

\item{Stabilization}{stabilization factor}

\item{MaxStabilizedMutrate}{mix factor}

\item{femaleMutationModel}{for females}

\item{femaleMutationRate}{rate}

\item{femaleMutationRange}{range}

\item{femaleMutationRate2}{rate 2}

\item{femaleMutationMatrix}{females matrix}

\item{maleMutationModel}{male matrix}

\item{maleMutationRate}{male rate}

\item{maleMutationRange}{male range}

\item{maleMutationRate2}{rate 2}

\item{maleMutationMatrix}{matrix}
}
\value{
Locus analysis.
}
\description{
FamiliasLocus: a function for reading Familias locus data.
}
\examples{
frequencies <- c(0.1, 0.2, 0.3, 0.4)
allelenames <- c("A", "B", "C", "D")
marker <- FamiliasLocus(frequencies, allelenames)
}
