% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fbroc.roc.R
\name{conf.fbroc.roc}
\alias{conf.fbroc.roc}
\title{Generates confidence intervals for the TPR for a range of FPRs or vice versa}
\usage{
\method{conf}{fbroc.roc}(roc, conf.level = 0.95, conf.for = "tpr",
  steps = 250, ...)
}
\arguments{
\item{roc}{Object of class \code{fbroc.roc}.}

\item{conf.level}{Confidence level to be used for the confidence intervals. Defaults to 0.95.}

\item{conf.for}{Use "tpr" to get confidence regions for the TPR at specific FPRs. Use "fpr"
instead for confidence regions for the FPR at specific TPRs.}

\item{steps}{Number of discrete steps at which the requested rate and the confidence region is calculated.
Defaults to 250.}

\item{...}{Further arguments, that are not used at this time.}
}
\value{
A data.frame containing either discrete TPR steps and estimates and confidence bounds for
FPR or vice versa, depending upon \code{conf.for}.
}
\description{
Calculates confidence intervals for the TPR at different FPR values or vice versa. The stepsize
at which the TPR or FPR is calculated can be set as needed.
}
\examples{
data(roc.examples)
example <- boot.roc(roc.examples$Cont.Pred, roc.examples$True.Class,
                    n.boot = 100)
conf(example, conf.for = "tpr", steps = 10) # get confidence regions for TPR at FPR
conf(example, conf.for = "fpr", steps = 10) # get confidence regions for FPR at TPR
}
\seealso{
\code{\link{boot.roc}}
}

