% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_fct.R
\name{fct_char_freq}
\alias{fct_char_freq}
\title{Reorder Factor Levels Based on Character Frequency at Positions}
\usage{
fct_char_freq(
  factor_vec,
  positions,
  case = FALSE,
  decreasing = TRUE,
  inplace = TRUE
)
}
\arguments{
\item{factor_vec}{A factor vector whose levels are to be reordered.}

\item{positions}{A vector of positive integers specifying the character positions to consider.}

\item{case}{Logical. Should the character comparison be case-sensitive? Default is \code{FALSE}.}

\item{decreasing}{Logical. Should the ordering be decreasing by frequency? Default is \code{TRUE}.}

\item{inplace}{Logical. If \code{TRUE}, returns a new factor vector with elements reordered to align with the new levels' order. If \code{FALSE}, returns a new factor vector with only the levels' order adjusted, leaving the data vector's elements' order unchanged. Defaults to \code{FALSE}.}
}
\value{
A factor vector with levels reordered based on the frequency of characters at specified positions.
}
\description{
Reorders the levels of a factor vector based on the frequency of characters at specified positions within the data.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'apricot', 'cherry', 'banana', 'banana', 'date'))

# Reorder based on characters at positions 1 and 2
fct_char_freq(factor_vec, positions = 1:2)

# Reorder, case-sensitive, decreasing order
fct_char_freq(factor_vec, positions = c(1, 3), case = TRUE)
}
\author{
Kai Guo
}
