% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{MCO}
\alias{MCO}
\title{Mithochondiral calcium overload (MCO) data set}
\format{Elements of MCO:\cr \code{..$intact}: \code{fdata} class object with
``intact cells''curves,\cr \itemize{ \item \code{"data"}: Matrix of class
\code{fdata} with 89 intact cells curves (rows) measured every 10 seconds
during an hour in isolated mouse cardiac cell. \item \code{"argvals"}, 360
discretization points from seond 0 to 3590. \item \code{"rangeval"}:
range(\code{"argvals"}). \item \code{"names"} list with: \code{main} an
overall title "Control Intact Treatment", \code{xlab} title for \code{x}
axis "seconds" and \code{ylab} title for \code{y} axis "Ca". }
\code{..$classintact}: Factor levels of ``intact cells'' curves: "1" control
group and "2" treatment group.\cr

\code{..$permea}: \code{fdata} class object with ``permeabilized cells''
curves (whose membrane has been removed), \itemize{ \item \code{"data"}:
Matrix of class \code{fdata} with 90 permeabilizzed cells curves (rows)
measured every 10 seconds during an hour in isolated mouse cardiac cell.
\item \code{"argvals"}, 360 discretization points from seond 0 to 3590.
\item \code{"rangeval"}: range(\code{"argvals"}). \item \code{"names"} list
with: \code{main} an overall title "Control Intact Treatment", \code{xlab}
title for \code{x} axis "seconds" and \code{ylab} title for \code{y} axis
"Ca". } \code{..$classpermea}: Factor levels of ``permeabilized cells''
curves: "1" control group and "2" treatment group.\cr}
\description{
The mithochondiral calcium overload (MCO) was measured in two groups
(control and treatment) every 10 seconds during an hour in isolated mouse
cardiac cells. In fact, due to technical reasons, the original experiment
[see Ruiz-Meana et al. (2000)] was performed twice, using both the "intact",
original cells and "permeabilized" cells (a condition related to the
mitochondrial membrane).
}
\note{
The structure of the curves during the initial period (first 180
seconds) of the experiment shows a erratic behavior (not very relevant in
the experiment context) during this period.
}
\examples{

data(MCO)
names(MCO)
par(mfrow=c(1,2))
plot(MCO$intact,col=MCO$classintact)
plot(MCO$permea,col=MCO$classpermea)

}
\references{
Ruiz--Meana M, Garcia-Dorado D, Pina P, Inserte J, Agullo L, Soler--Soler J.
Cariporide preserves mitochondrial proton gradient and delays ATP depletion
in cardiomyocytes during ischemic conditions. \emph{American Journal
Physiology Heart Circulatori Physiology}. 2003 Sep;285(3):H999--1006.
}
\keyword{datasets}
